package xin.alum.aio;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AttributeKey;
import lombok.SneakyThrows;
import org.springframework.stereotype.Component;
import xin.alum.aio.constant.AioAttr;
import xin.alum.aio.constant.AioPlatform;
import xin.alum.aio.groups.Sessions;
import xin.alum.aio.handler.AioReceiver;
import xin.alum.aio.model.Aio;
import xin.alum.aio.model.Events;

/**
 * @author Alum(alum @ live.cn)
 * @date 2021/8/7 9:53 1231321
 */
@Component
public class AioReciveService extends AioReceiver {

    String groupKey = "test_group";

    @Override
    public boolean onHandShake(Channel ch, FullHttpRequest req, FullHttpResponse res) {
        String tokens = (String) sessions.getAttr(ch, "token");
        res.setStatus(HttpResponseStatus.UNAUTHORIZED);
        return tokens != null;
    }

    /**
     * @param ch
     */
    @Override
    public void onHandShaked(Channel ch) {
        String token = ch.attr(AttributeKey.valueOf("token")).toString();
        sessions.bindUser(ch, token, AioPlatform.WINDOWS, "");
    }

    @SneakyThrows
    @Override
    public void onRecive(Channel ch, Events s) {
        long l = System.currentTimeMillis();
        Sessions sessions = groups.get(groupKey);
        if (!sessions.contains(ch)) {
            sessions = groups.bind(ch, groupKey);
        }
        Aio.Data d = (Aio.Data) s.unpack(Aio.Data.class);
        final Events events = new Events(s.getKey());
        Aio.Data.Builder b = Aio.Data.newBuilder();
        b.putAllAttrs(d.getAttrsMap());
        //b.putAttrs("uid", ch.attr(AioAttr.UID).get());
        events.setData(b.build());
        groups.sends(groupKey, events);
//        ChannelGroupFuture f = sessions.sends(events);
//        int r = sessions.size();
//        f.addListener(t -> {
//            if (s.refCnt() > 0) {
//                s.release(s.refCnt());
//            }
//            long c = System.currentTimeMillis() - l;
//            if (f.isPartialFailure()) {
//                logger.warn("{}向【{}】发【{}】人用时-{}", ch, groupKey, r, c);
//            }
//        });

    }
}
