package xin.alum.aio;

import lombok.SneakyThrows;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

/**
 * Spring boot 启动后自动启动AioSocksServer
 *
 * @author alum(alum @ live.cn)
 * @date 2021/8/2 12:38
 */
@Component
public class AioStarter implements ApplicationListener<ApplicationStartedEvent> {
    private  final   ClusterMessage clusterMessage;

    public AioStarter(ClusterMessage clusterMessage) {
        this.clusterMessage = clusterMessage;
    }

    @SneakyThrows
    @Override
    public  void onApplicationEvent(@NonNull ApplicationStartedEvent applicationStartedEvent) {
        Aio.start(clusterMessage);
    }
}
