package xin.alum.aio.controller;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping("test")
public class TestController {

    @Value("spring.profiles.active")
    String active;


    @RequestMapping(value = "/", method = RequestMethod.GET)
    @ResponseBody
    public String get() {
        return "Index";
    }

    @RequestMapping(value = "/mono", method = RequestMethod.GET)
    @ResponseBody
    public Mono<String> mono() {
        return Mono.just("Index");
    }
}
