/*
 * Decompiled with CFR 0.152.
 */
package xin.alum.aio;

import io.netty.channel.group.ChannelGroupFuture;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;
import xin.alum.aio.groups.SessionGroups;
import xin.alum.aio.groups.Sessions;
import xin.alum.aio.model.Pusher;
import xin.alum.aio.util.ApplicationContextUtil;

@Component
public class ClusterMessage
implements xin.alum.aio.groups.ClusterMessage {
    protected final InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    private final Sessions sessions;
    private final SessionGroups groups;
    private int count;

    public ClusterMessage(Sessions sessions, SessionGroups groups) {
        this.sessions = sessions;
        this.groups = groups;
    }

    public void onMessage(byte[] b) {
        if (this.count++ % 1000 == 0) {
            this.logger.info("\u5f53\u524d\u53d1\u9001\u6d88\u606f\u6570\uff1a{}", (Object)this.count);
        }
        GlobalEventExecutor.INSTANCE.execute(() -> {
            StopWatch w = new StopWatch("ClusterMessage");
            w.start("deserialize");
            Jackson2JsonRedisSerializer json = (Jackson2JsonRedisSerializer)ApplicationContextUtil.getBean(Jackson2JsonRedisSerializer.class);
            Pusher p = (Pusher)json.deserialize(b);
            w.stop();
            w.start("send");
            Sessions s = this.groups.get(p.getRecipient());
            ChannelGroupFuture f = s.sends(p.getData());
            f.addListener(t -> {
                long c = System.currentTimeMillis() - p.getData().getTimestamp();
                if (c > 200L || f.isPartialFailure()) {
                    this.logger.error("\u96c6\u7fa4\u5411\u3010{}\u3011\u7fa4\u53d1\u3010{}\u3011\u4eba\u7528\u65f6-{}", new Object[]{p.getRecipient(), s.size(), c});
                }
            });
            w.stop();
            if (w.getTotalTimeMillis() > 200L) {
                this.logger.error("\u96c6\u7fa4\u5411\u3010{}\u3011\u7fa4\u53d1\u3010{}\u3011\u4eba\u7528\u65f6-{},\r\n{}", new Object[]{p.getRecipient(), s.size(), w.getTotalTimeMillis(), w.prettyPrint()});
            }
        });
    }
}

