package xin.xihc.utils.bean;

import xin.xihc.utils.common.DateUtil;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * DateBean
 *
 * @author Leo.Xi
 * @version 1.0
 * @date 2019/8/11 14:04
 * @since 1.19.8
 */
public class DateBean {

    private Date date;

    public DateBean() {
        this.date = new Date();
    }

    public DateBean(Date date) {
        this.date = date;
    }

    /**
     * param timeMillis 毫秒值
     */
    public DateBean(long timeMillis) {
        this.date = new Date(timeMillis);
    }

    /**
     * 获取Date值
     *
     * @return
     */
    public Date toDate() {
        return this.date;
    }

    /**
     * 转为时间戳类型
     *
     * @return
     */
    public Timestamp toTimestamp() {
        return new Timestamp(this.date.getTime());
    }

    /**
     * 转为time
     *
     * @return
     */
    public Time toTime() {
        return new Time(this.date.getTime());
    }

    /**
     * 转为sqlDate
     *
     * @return
     */
    public java.sql.Date toSqlDate() {
        return new java.sql.Date(this.date.getTime());
    }

    /**
     * 格式化时间
     *
     * @param pattern 格式化格式
     * @return
     */
    public String format(String pattern) {
        SimpleDateFormat sf = new SimpleDateFormat(pattern);
        return sf.format(this.date);
    }

    /**
     * 是否在when之前
     *
     * @param when 时间
     * @return
     */
    public boolean before(Date when) {
        return this.date.before(when);
    }

    /**
     * 是否在when之后
     *
     * @param when 时间
     * @return
     */
    public boolean after(Date when) {
        return this.date.after(when);
    }

    /**
     * <p><code>add(Calendar.DAY_OF_MONTH, -5)</code>.
     *
     * @param field 是增加天数、小时、分钟、月、年
     * @param delta 差值，增加或减少的值
     * @return new DateBean
     */
    public DateBean getDateOf(int field, int delta) {
        Calendar cld = Calendar.getInstance();
        cld.setTime(this.date);
        cld.add(field, delta);
        return new DateBean(cld.getTime());
    }

    /**
     * 获取该时间戳对应的00:00:00.000的时间戳
     *
     * @param delta 天数，0为当天的
     * @return
     * @author Leo.Xi
     * @date 2020/5/31
     * @since 0.0.1
     */
    public Date getZeroTimestamp(int delta) {
        return new Date(DateUtil.getZeroTimestamp(this.date.getTime(), delta));
    }

    /**
     * 获取半夜23:59:59的毫秒数
     *
     * @param delta 天数，0为当天的
     * @return
     * @author Leo.Xi
     * @date 2020/5/31
     * @since 0.0.1
     */
    public Date getMidOfNightTime(int delta) {
        return new Date(DateUtil.getMidOfNightTime(this.date.getTime(), delta));
    }

}
