package xin.xihc.utils.common;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 最近最少使用缓存
 * LRU是Least Recently Used的缩写，即最近最少使用，是一种常用的页面置换算法，选择最近最久未使用的页面予以淘汰。
 *
 * @author Leo.Xi
 * @date 2020/1/2
 * @since 1.0
 **/
public class LruCache<K, V> extends LinkedHashMap<K, V> {

    /** 最大缓存对象数量 */
    private final int MAX_CACHE_SIZE;

    public LruCache(int cacheSize) {
        super((int) Math.ceil(cacheSize / 0.75) + 1, 0.75f, true);
        MAX_CACHE_SIZE = cacheSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return size() > MAX_CACHE_SIZE;
    }

}