/*
 * Decompiled with CFR 0.152.
 */
package xin.xihc.utils.bean;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import xin.xihc.utils.common.DateUtil;

public class DateBean {
    private Date date;

    public DateBean() {
        this.date = new Date();
    }

    public DateBean(Date date) {
        this.date = date;
    }

    public DateBean(long timeMillis) {
        this.date = new Date(timeMillis);
    }

    public Date toDate() {
        return this.date;
    }

    public Timestamp toTimestamp() {
        return new Timestamp(this.date.getTime());
    }

    public Time toTime() {
        return new Time(this.date.getTime());
    }

    public java.sql.Date toSqlDate() {
        return new java.sql.Date(this.date.getTime());
    }

    public String format(String pattern) {
        SimpleDateFormat sf = new SimpleDateFormat(pattern);
        return sf.format(this.date);
    }

    public boolean before(Date when) {
        return this.date.before(when);
    }

    public boolean after(Date when) {
        return this.date.after(when);
    }

    public DateBean getDateOf(int field, int delta) {
        Calendar cld = Calendar.getInstance();
        cld.setTime(this.date);
        cld.add(field, delta);
        return new DateBean(cld.getTime());
    }

    public Date getZeroTimestamp(int delta) {
        return new Date(DateUtil.getZeroTimestamp(this.date.getTime(), delta));
    }

    public Date getMidOfNightTime(int delta) {
        return new Date(DateUtil.getMidOfNightTime(this.date.getTime(), delta));
    }
}

