/*
 * Decompiled with CFR 0.152.
 */
package xin.xihc.utils.common;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class BigDecimalUtils {
    private RoundingMode roundingMode = RoundingMode.HALF_UP;
    private int scale = 4;

    public BigDecimalUtils() {
    }

    public BigDecimalUtils(int scale, RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
        this.scale = scale;
    }

    public void setRoundingMode(RoundingMode mode) {
        this.roundingMode = mode;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public <T extends Number> BigDecimal add(T ... bn) {
        BigDecimal res = BigDecimal.ZERO;
        if (null == bn || bn.length < 1) {
            return res;
        }
        for (int i = 0; i < bn.length; ++i) {
            if (null == bn[i]) continue;
            res = res.add(BigDecimal.valueOf(((Number)bn[i]).doubleValue()));
        }
        return res.setScale(this.scale, this.roundingMode);
    }

    public <T extends Number> BigDecimal subtract(T b1, T ... bn) {
        return this.subtract(false, b1, (Number[])bn);
    }

    public <T extends Number> BigDecimal subtract(Boolean isZero, T b1, T ... bn) {
        BigDecimal res = BigDecimal.ZERO;
        if (null != b1) {
            res = BigDecimal.valueOf(b1.doubleValue());
        }
        for (T b : bn) {
            if (null == b) continue;
            res = res.subtract(BigDecimal.valueOf(((Number)b).doubleValue()));
        }
        if (isZero.booleanValue() && res.compareTo(BigDecimal.ZERO) <= 0) {
            return BigDecimal.ZERO.setScale(this.scale, this.roundingMode);
        }
        return res.setScale(this.scale, this.roundingMode);
    }

    public <T extends Number> BigDecimal divide(T b1, T b2) {
        return this.divide(b1, b2, BigDecimal.ZERO);
    }

    public <T extends Number> BigDecimal divide(T b1, T b2, BigDecimal defaultValue) {
        if (null == b1 || null == b2) {
            return defaultValue.setScale(this.scale, this.roundingMode);
        }
        try {
            return BigDecimal.valueOf(b1.doubleValue()).divide(BigDecimal.valueOf(b2.doubleValue()), this.scale, this.roundingMode);
        }
        catch (Exception e) {
            return defaultValue.setScale(this.scale, this.roundingMode);
        }
    }

    public <T extends Number> BigDecimal multiply(T b1, T ... bn) {
        BigDecimal res = BigDecimal.ZERO;
        if (null == b1 || b1.doubleValue() == 0.0) {
            return res;
        }
        res = BigDecimal.valueOf(b1.doubleValue());
        for (T b : bn) {
            if (null == b) continue;
            res = res.multiply(BigDecimal.valueOf(((Number)b).doubleValue()));
        }
        return res.setScale(this.scale, this.roundingMode);
    }
}

