/*
 * Decompiled with CFR 0.152.
 */
package xin.xihc.utils.common;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import xin.xihc.utils.common.CharsetUtil;

public final class CommonUtil {
    public static char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String newGuid(boolean isUpp) {
        String res = UUID.randomUUID().toString().replaceAll("-", "");
        return isUpp ? res.toUpperCase() : res;
    }

    public static String md5Str(String cont, boolean isUpp) {
        try {
            byte[] strTemp = cont.getBytes(CharsetUtil.UTF8);
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(strTemp);
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = HEX_DIGITS[byte0 >>> 4 & 0xF];
                str[k++] = HEX_DIGITS[byte0 & 0xF];
            }
            return isUpp ? new String(str).toUpperCase() : new String(str);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final boolean isNullEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof String) {
            return "".equals(((String)obj).trim());
        }
        if (obj.getClass().isArray()) {
            return ((Object[])obj).length < 1;
        }
        if (obj instanceof List) {
            return ((List)obj).size() < 1;
        }
        return false;
    }

    public static final boolean isNotNullEmpty(Object obj) {
        return !CommonUtil.isNullEmpty(obj);
    }

    public static List<Field> getAllFields(Class<?> clazz, boolean containFinal, boolean containStatic) {
        ArrayList<Field> res = new ArrayList<Field>(10);
        if (null == clazz) {
            return res;
        }
        ArrayList<Field> temp = null;
        while (!clazz.equals(Object.class)) {
            temp = new ArrayList<Field>(10);
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                if (!containStatic && Modifier.isStatic(field.getModifiers()) || !containFinal && Modifier.isFinal(field.getModifiers())) continue;
                temp.add(field);
            }
            res.addAll(0, temp);
            clazz = clazz.getSuperclass();
        }
        return res;
    }

    public static Map<String, Object> objToMap(Object obj, boolean containsNull) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : CommonUtil.getAllFields(obj.getClass(), true, true)) {
            field.setAccessible(true);
            try {
                Object val = field.get(obj);
                if (containsNull) {
                    map.put(field.getName(), val);
                    continue;
                }
                if (null == val) continue;
                map.put(field.getName(), val);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static String null2Str(String cont, String defaultValue) {
        return CommonUtil.isNullEmpty(cont) ? defaultValue : cont;
    }

    public static StackTraceElement getStackTrace(int offset) {
        StackTraceElement[] stackTrace;
        if (offset < 0) {
            offset = 0;
        }
        if (offset + 1 > (stackTrace = new Throwable().getStackTrace()).length - 1) {
            return stackTrace[stackTrace.length - 1];
        }
        return stackTrace[offset + 1];
    }
}

