/*
 * Decompiled with CFR 0.152.
 */
package xin.xihc.utils.common;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import xin.xihc.utils.bean.DateBean;

public final class DateUtil {
    public static final String FORMAT_DATE = "yyyy-MM-dd";
    public static final String FORMAT_DATE_NUM = "yyyyMMdd";
    public static final String FORMAT_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_DATETIME_NUM = "yyyyMMddHHmmss";
    public static final String FORMAT_DATETIME_MS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String FORMAT_DATETIME_MS_NUM = "yyyyMMddHHmmssSSS";
    public static final String FORMAT_TIME = "HH:mm:ss";
    public static final String FORMAT_TIME_NUM = "HHmmss";

    public static String getNow() {
        SimpleDateFormat sf = new SimpleDateFormat(FORMAT_DATETIME);
        return sf.format(System.currentTimeMillis());
    }

    public static String getNow(String pattern) {
        SimpleDateFormat sf = new SimpleDateFormat(pattern);
        return sf.format(System.currentTimeMillis());
    }

    public static String getDateTimeFromNow(int seconds, String formater) {
        SimpleDateFormat sf = new SimpleDateFormat(formater);
        Calendar cld = Calendar.getInstance();
        cld.add(13, seconds);
        return sf.format(cld.getTime());
    }

    public static String getDateTimeFromThen(String then, int seconds, String formater) {
        SimpleDateFormat sf = new SimpleDateFormat(formater);
        Calendar cld = Calendar.getInstance();
        String ret = null;
        try {
            Date temp = sf.parse(then);
            cld.setTime(temp);
            cld.add(13, seconds);
            ret = sf.format(cld.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            ret = null;
        }
        return ret;
    }

    public static String formatDateTime(Date date, String formater) {
        SimpleDateFormat sf = new SimpleDateFormat(formater);
        return sf.format(date);
    }

    public static Date toDate(String dateTime, String formater) {
        SimpleDateFormat sf = new SimpleDateFormat(formater);
        Date ret = null;
        try {
            ret = sf.parse(dateTime);
        }
        catch (ParseException e) {
            return ret;
        }
        return ret;
    }

    public static long toTimeStamp(String dateTime, String formater) {
        SimpleDateFormat sf = new SimpleDateFormat(formater);
        Date ret = null;
        try {
            ret = sf.parse(dateTime);
        }
        catch (ParseException e) {
            return 0L;
        }
        return ret.getTime();
    }

    public static int todayBetween(String start, String end, String formater) {
        long today;
        long endDate;
        long startDate;
        block10: {
            if (null == formater || "".equals(formater)) {
                return -1;
            }
            startDate = 0L;
            endDate = Long.MAX_VALUE;
            today = new Long(DateUtil.getNow(formater).replaceAll("[-: /]", ""));
            try {
                if (start != null && !"".equals(start)) {
                    if (start.length() == formater.length()) {
                        startDate = new Long(start.replaceAll("[-: /]", ""));
                    } else {
                        return -1;
                    }
                }
                if (end == null || "".equals(end)) break block10;
                if (end.length() == formater.length()) {
                    endDate = new Long(end.replaceAll("[-: /]", ""));
                    break block10;
                }
                return -1;
            }
            catch (Exception e) {
                return -1;
            }
        }
        if (startDate > endDate) {
            return -2;
        }
        if (today < startDate) {
            return 0;
        }
        if (today > endDate) {
            return 2;
        }
        return 1;
    }

    public static int todayBetween(Date start, Date end, String formater) {
        if (null == formater || "".equals(formater)) {
            return -1;
        }
        long startDate = 0L;
        long endDate = Long.MAX_VALUE;
        long today = new Long(DateUtil.getNow(formater).replaceAll("[-: /]", ""));
        try {
            if (start != null) {
                startDate = new Long(DateUtil.formatDateTime(start, formater).replaceAll("[-: /]", ""));
            }
            if (end != null) {
                endDate = new Long(DateUtil.formatDateTime(end, formater).replaceAll("[-: /]", ""));
            }
        }
        catch (Exception e) {
            return -1;
        }
        if (startDate > endDate) {
            return -2;
        }
        if (today < startDate) {
            return 0;
        }
        if (today > endDate) {
            return 2;
        }
        return 1;
    }

    public static int dayBetween(String day, String start, String end, String formater) {
        long then;
        long endDate;
        long startDate;
        block13: {
            if (null == formater || "".equals(formater)) {
                return -1;
            }
            startDate = 0L;
            endDate = Long.MAX_VALUE;
            then = 1L;
            try {
                if (day != null && !"".equals(day)) {
                    if (day.length() == formater.length()) {
                        then = new Long(day.replaceAll("[-: /]", ""));
                    } else {
                        return -1;
                    }
                }
                if (start != null && !"".equals(start)) {
                    if (start.length() == formater.length()) {
                        startDate = new Long(start.replaceAll("[-: /]", ""));
                    } else {
                        return -1;
                    }
                }
                if (end == null || "".equals(end)) break block13;
                if (end.length() == formater.length()) {
                    endDate = new Long(end.replaceAll("[-: /]", ""));
                    break block13;
                }
                return -1;
            }
            catch (Exception e) {
                return -1;
            }
        }
        if (startDate > endDate) {
            return -2;
        }
        if (then < startDate) {
            return 0;
        }
        if (then > endDate) {
            return 2;
        }
        return 1;
    }

    public static int dayBetween(Date day, Date start, Date end) {
        long startDate = 0L;
        long endDate = Long.MAX_VALUE;
        long then = 1L;
        try {
            if (day != null) {
                then = day.getTime();
            }
            if (start != null) {
                startDate = start.getTime();
            }
            if (end != null) {
                endDate = end.getTime();
            }
        }
        catch (Exception e) {
            return -1;
        }
        if (startDate > endDate) {
            return -2;
        }
        if (then < startDate) {
            return 0;
        }
        if (then > endDate) {
            return 2;
        }
        return 1;
    }

    public static long getZeroTimestamp(long timestamp, int delta) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp);
        calendar.add(5, delta);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date zero = calendar.getTime();
        return zero.getTime();
    }

    public static long getMidOfNightTime(int delta) {
        return DateUtil.getMidOfNightTime(System.currentTimeMillis(), delta);
    }

    public static long getMidOfNightTime(long timestamp, int delta) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp);
        calendar.add(5, delta);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static DateBean from(String dateString, String datePattern) {
        Date date = DateUtil.toDate(dateString, datePattern);
        if (null == date) {
            return null;
        }
        return new DateBean(date);
    }
}

