/*
 * Decompiled with CFR 0.152.
 */
package xin.xihc.utils.common;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class FileUtil {
    private FileUtil() {
    }

    public static String readFileToStr(File file) throws IOException {
        byte[] bytes = FileUtil.readFileToBytes(file);
        return new String(bytes);
    }

    public static String readFileToStr(File file, Charset charset) throws IOException {
        byte[] bytes = FileUtil.readFileToBytes(file);
        return new String(bytes, charset);
    }

    public static byte[] readFileToBytes(File file) throws IOException {
        Objects.requireNonNull(file, "file is null");
        return FileUtil.readInputStream(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        Objects.requireNonNull(inputStream, "inputStream is null");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(inputStream.available());
        byte[] buffer = new byte[1024];
        try {
            int temp;
            while ((temp = inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, temp);
            }
        }
        finally {
            inputStream.close();
        }
        return baos.toByteArray();
    }

    public static List<String> readLines(File file, Charset charset) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            List<String> list = FileUtil.readLines(in, charset);
            return list;
        }
    }

    public static List<String> readLines(InputStream inputStream, Charset charset) throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        FileUtil.readLines(inputStream, charset, (rowNo, lineData, eof) -> list.add(lineData));
        return list;
    }

    public static void readLines(InputStream inputStream, Charset charset, LineCallback callback) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(inputStream, charset);){
            BufferedReader reader = new BufferedReader(isr);
            long index = 1L;
            String line = reader.readLine();
            do {
                String cur = line;
                line = reader.readLine();
                callback.onLine(index++, cur, line == null);
            } while (line != null);
        }
    }

    public static void saveToFile(String data, File toFile, boolean append) throws IOException {
        FileUtil.saveToFile(data.getBytes(), toFile, append);
    }

    public static void saveToFile(String data, File toFile, boolean append, Charset charset) throws IOException {
        FileUtil.saveToFile(data.getBytes(charset), toFile, append);
    }

    public static void saveToFile(byte[] data, File toFile, boolean append) throws IOException {
        Objects.requireNonNull(data, "data is null");
        Objects.requireNonNull(toFile, "toFIle is null");
        if (!toFile.getParentFile().exists()) {
            toFile.getParentFile().mkdirs();
        }
        if (!toFile.exists()) {
            toFile.createNewFile();
        }
        try (FileOutputStream fos = new FileOutputStream(toFile, append);){
            fos.write(data);
            fos.flush();
        }
    }

    public static void deleteFile(File f, Predicate<File> filter) {
        File[] files;
        if (null == f || !f.exists()) {
            return;
        }
        if (f.isDirectory() && null != (files = f.listFiles())) {
            for (File file : files) {
                FileUtil.deleteFile(file, filter);
            }
        }
        if (filter != null) {
            if (filter.test(f)) {
                f.delete();
            }
        } else {
            f.delete();
        }
    }

    @FunctionalInterface
    public static interface LineCallback {
        public void onLine(long var1, String var3, boolean var4);
    }
}

