/*
 * Decompiled with CFR 0.152.
 */
package xin.xihc.utils.common;

import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.scheduling.support.CronTrigger;

public final class ScheduleUtils {
    private static int CORE_THREAD_COUNT = 0;
    private static final ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(CORE_THREAD_COUNT, (ThreadFactory)new CustomizableThreadFactory("schedule-pool-"));
    private static final ConcurrentTaskScheduler TASK_SCHEDULER = new ConcurrentTaskScheduler(EXECUTOR);
    private static final ConcurrentHashMap<String, ScheduledFuture<?>> TASK_MANAGER = new ConcurrentHashMap(256);

    private ScheduleUtils() {
    }

    public static void setScheduledExecutor(ScheduledExecutorService scheduledExecutor) {
        TASK_SCHEDULER.setScheduledExecutor(scheduledExecutor);
    }

    public static void setCorePoolSize(int corePoolSize) {
        if (EXECUTOR instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)((Object)EXECUTOR)).setCorePoolSize(corePoolSize);
        }
    }

    private static void checkCoreTheadCount() {
        if (TASK_MANAGER.size() > CORE_THREAD_COUNT) {
            ScheduleUtils.setCorePoolSize(++CORE_THREAD_COUNT);
        }
    }

    public static void putTask(String key, String cronExpression, Runnable task) {
        ScheduleUtils.newTask(key, (Trigger)new CronTrigger(cronExpression), task, true);
    }

    public static void addTask(String key, String cronExpression, Runnable task) {
        ScheduleUtils.newTask(key, (Trigger)new CronTrigger(cronExpression), task, false);
    }

    private static void newTask(String key, Trigger trigger, Runnable task, boolean override) {
        ScheduledFuture<?> scheduledFuture = TASK_MANAGER.get(key);
        if (scheduledFuture != null) {
            if (override) {
                scheduledFuture.cancel(true);
            } else {
                throw new IllegalArgumentException("key exists");
            }
        }
        ScheduledFuture schedule = TASK_SCHEDULER.schedule(task, trigger);
        TASK_MANAGER.put(key, schedule);
        ScheduleUtils.checkCoreTheadCount();
    }

    public static void putTaskOnce(String key, Date startTime, Runnable task) {
        ScheduledFuture<?> scheduledFuture = TASK_MANAGER.get(key);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        ScheduledFuture schedule = TASK_SCHEDULER.schedule(task, startTime);
        TASK_MANAGER.put(key, schedule);
        ScheduleUtils.checkCoreTheadCount();
    }

    public static void putTaskAtFixedRate(String key, Date startTime, long period, Runnable task) {
        ScheduledFuture<?> scheduledFuture = TASK_MANAGER.get(key);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        ScheduledFuture schedule = TASK_SCHEDULER.scheduleAtFixedRate(task, startTime, period);
        TASK_MANAGER.put(key, schedule);
        ScheduleUtils.checkCoreTheadCount();
    }

    public static void putTaskWithFixedDelay(String key, Date startTime, long period, Runnable task) {
        ScheduledFuture<?> scheduledFuture = TASK_MANAGER.get(key);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        ScheduledFuture schedule = TASK_SCHEDULER.scheduleWithFixedDelay(task, startTime, period);
        TASK_MANAGER.put(key, schedule);
        ScheduleUtils.checkCoreTheadCount();
    }

    public static void removeTask(String key) {
        ScheduledFuture<?> scheduledFuture = TASK_MANAGER.get(key);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
            TASK_MANAGER.remove(key);
        }
    }

    public static boolean existsTask(String key) {
        return TASK_MANAGER.containsKey(key);
    }
}

