/*
 * Decompiled with CFR 0.152.
 */
package xin.xihc.utils.common;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.xihc.utils.common.CommonUtil;

public class XMLUtil {
    private static final Logger LOG = LoggerFactory.getLogger(XMLUtil.class);

    private XMLUtil() {
    }

    public static String convertToXml(Object obj) {
        return XMLUtil.convertToXmlForEncode(obj, "UTF-8");
    }

    public static String convertToXmlForEncode(Object obj, String encoding) {
        if (null == obj) {
            return null;
        }
        String result = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)false);
            marshaller.setProperty("jaxb.encoding", (Object)encoding);
            marshaller.setProperty("jaxb.fragment", (Object)false);
            try (StringWriter writer = new StringWriter();){
                marshaller.marshal(obj, (Writer)writer);
                result = writer.toString();
            }
        }
        catch (Exception e) {
            LOG.error("XMLUtil.convertToXmlForEncode() Exception at " + CommonUtil.getStackTrace(1), (Throwable)e);
        }
        return result;
    }

    public static void saveToXmlFile(Object obj, File file, boolean appended) throws JAXBException, IOException {
        Objects.requireNonNull(obj, "\u4fdd\u5b58\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        try (FileWriter fw = new FileWriter(file, appended);){
            marshaller.marshal(obj, (Writer)fw);
        }
    }

    public static <T> T parseToObject(String xmlStr, Class<T> clazz) {
        Object xmlObject = null;
        try {
            xmlStr = XMLUtil.escapingToXml(xmlStr);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            try (StringReader sr = new StringReader(xmlStr);){
                xmlObject = unmarshaller.unmarshal((Reader)sr);
            }
        }
        catch (JAXBException e) {
            LOG.error("XMLUtil.parseToObject() Exception at " + CommonUtil.getStackTrace(1), (Throwable)e);
        }
        return (T)xmlObject;
    }

    public static <T> T parseToObject(File xmlFile, Class<T> clazz) {
        Object xmlObject = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            try (FileReader fr = new FileReader(xmlFile);){
                xmlObject = unmarshaller.unmarshal((Reader)fr);
            }
            catch (IOException e) {
                LOG.error("XMLUtil.parseToObject() Exception at " + CommonUtil.getStackTrace(1), (Throwable)e);
            }
        }
        catch (JAXBException e) {
            LOG.error("XMLUtil.parseToObject() Exception at " + CommonUtil.getStackTrace(1), (Throwable)e);
        }
        return (T)xmlObject;
    }

    public static String xmlEscaping(String xmlStr) {
        return xmlStr.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }

    public static String escapingToXml(String xmlStr) {
        return xmlStr.replaceAll("&amp;", "&").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&apos;", "'");
    }
}

