/*
 * Decompiled with CFR 0.152.
 */
package xin.xihc.utils.configfile;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.slf4j.Logger;
import xin.xihc.utils.common.CommonUtil;
import xin.xihc.utils.common.DateUtil;
import xin.xihc.utils.configfile.IConfig;
import xin.xihc.utils.log.LogUtil;

public final class ConfigFileUtil {
    private static final String COMMENTS_START = "#";
    private static Logger LOG = LogUtil.getLogger(ConfigFileUtil.class);

    private ConfigFileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeMap<String, String> readAllConfig(String fileName) throws IOException {
        String string = fileName.intern();
        synchronized (string) {
            File f = new File(fileName);
            if (!f.exists()) {
                return new TreeMap<String, String>();
            }
            return ConfigFileUtil.readAllConfig(new FileInputStream(f));
        }
    }

    /*
     * Exception decompiling
     */
    public static TreeMap<String, String> readAllConfig(InputStream input) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T extends IConfig> T readConfig(Class<T> clazz, boolean readNull) {
        Objects.requireNonNull(clazz, "clazz is null");
        IConfig res = null;
        try {
            res = (IConfig)clazz.newInstance();
            String filePath = res.filePath();
            TreeMap<String, String> allConfig = ConfigFileUtil.readAllConfig(filePath);
            res = ConfigFileUtil.convertToConfigBean(allConfig, clazz, readNull);
        }
        catch (Exception e) {
            LOG.error("ConfigFileUtil.readConfig() Exception at " + CommonUtil.getStackTrace(1), (Throwable)e);
            res = null;
        }
        return (T)res;
    }

    public static <T extends IConfig> T convertToConfigBean(Map<String, String> allConfig, Class<T> clazz, boolean convertNull) {
        Objects.requireNonNull(allConfig, "allConfig is null");
        Objects.requireNonNull(clazz, "clazz is null");
        IConfig res = null;
        try {
            res = (IConfig)clazz.newInstance();
            String prefix = res.prefix();
            if (!convertNull && allConfig.size() < 1) {
                return (T)res;
            }
            List<Field> fields = CommonUtil.getAllFields(clazz, false, false);
            block4: for (Field field : fields) {
                field.setAccessible(true);
                Class<?> type = field.getType();
                String key = prefix + "." + field.getName();
                String val = allConfig.get(key);
                try {
                    if (null == val) {
                        if (!convertNull) continue;
                        field.set(res, null);
                        continue;
                    }
                    if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                        field.set(res, Integer.valueOf(val));
                        continue;
                    }
                    if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                        field.set(res, Double.valueOf(val));
                        continue;
                    }
                    if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                        field.set(res, Float.valueOf(val));
                        continue;
                    }
                    if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
                        field.set(res, Byte.valueOf(val));
                        continue;
                    }
                    if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                        field.set(res, Long.valueOf(val));
                        continue;
                    }
                    if (type.equals(Short.TYPE) || type.equals(Short.class)) {
                        field.set(res, Short.valueOf(val));
                        continue;
                    }
                    if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                        field.set(res, Boolean.valueOf(val));
                        continue;
                    }
                    if (field.getType().isEnum()) {
                        ?[] t;
                        for (Object item : t = field.getType().getEnumConstants()) {
                            if (!item.toString().equalsIgnoreCase(val)) continue;
                            field.set(res, item);
                            continue block4;
                        }
                        continue;
                    }
                    if (Map.class.isAssignableFrom(field.getType())) continue;
                    field.set(res, val);
                }
                catch (Exception e) {
                    LOG.error("field.set():", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOG.error("ConfigFileUtil.convertToConfigBean() Exception at " + CommonUtil.getStackTrace(1), (Throwable)e);
        }
        return (T)res;
    }

    public static <T extends IConfig> T readConfigStream(InputStream input, Class<T> clazz, boolean readNull) throws IOException {
        TreeMap<String, String> allConfig = ConfigFileUtil.readAllConfig(input);
        return ConfigFileUtil.convertToConfigBean(allConfig, clazz, readNull);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends IConfig> boolean saveConfig(T conf) {
        boolean res = false;
        if (null == conf) {
            return res;
        }
        try {
            TreeMap<String, String> allConfig = ConfigFileUtil.readAllConfig(conf.filePath());
            String string = conf.filePath();
            synchronized (string) {
                List<Field> fields = CommonUtil.getAllFields(conf.getClass(), false, false);
                for (Field field : fields) {
                    field.setAccessible(true);
                    Object valObj = field.get(conf);
                    if (null == valObj) continue;
                    allConfig.put(conf.prefix() + "." + field.getName(), valObj.toString().trim());
                }
                File f = new File(conf.filePath());
                if (!f.exists()) {
                    if (!f.getParentFile().exists()) {
                        f.getParentFile().mkdirs();
                    }
                    f.createNewFile();
                    f.setWritable(true);
                }
                try (FileWriter fw = new FileWriter(f);
                     BufferedWriter bw = new BufferedWriter(fw);){
                    bw.write(COMMENTS_START + DateUtil.getNow() + "\u4fee\u6539");
                    bw.newLine();
                    String lastPrefix = "";
                    for (String key : allConfig.keySet()) {
                        String prefix = key.substring(0, key.lastIndexOf("."));
                        if (!lastPrefix.equals(prefix)) {
                            lastPrefix = prefix;
                            bw.newLine();
                            bw.write(COMMENTS_START + prefix + "\u7684\u5c5e\u6027");
                            bw.newLine();
                        }
                        bw.write(key + "=" + allConfig.get(key));
                        bw.newLine();
                    }
                    bw.flush();
                    res = true;
                }
            }
        }
        catch (Exception e) {
            LOG.error("ConfigFileUtil.save() Exception at " + CommonUtil.getStackTrace(1), (Throwable)e);
            res = false;
        }
        return res;
    }
}

