/*
 * Decompiled with CFR 0.152.
 */
package xin.xihc.utils.flatmap;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import xin.xihc.utils.common.CommonUtil;
import xin.xihc.utils.flatmap.FlatMapType;

public class FlatMap {
    private LinkedHashMap<String, Object> _data_new = new LinkedHashMap(16);
    private LinkedHashMap<String, FlatMapType> key2Type = new LinkedHashMap(16);

    public FlatMap(Object val) {
        if (val instanceof List) {
            this.parseListType(null, (List)val);
        } else {
            this.parseMapType(null, (Map)val);
        }
    }

    private FlatMapType getType(Object obj) {
        if (null == obj) {
            return FlatMapType.OBJECT;
        }
        if (obj instanceof List) {
            return FlatMapType.LIST;
        }
        if (obj instanceof String) {
            return FlatMapType.STRING;
        }
        if (obj instanceof Integer) {
            return FlatMapType.INTEGER;
        }
        if (obj instanceof Long) {
            return FlatMapType.LONG;
        }
        if (obj instanceof Boolean) {
            return FlatMapType.BOOLEAN;
        }
        if (obj instanceof Double) {
            return FlatMapType.DOUBLE;
        }
        if (obj instanceof Map) {
            return FlatMapType.MAP;
        }
        return FlatMapType.OBJECT;
    }

    private Class toClass(FlatMapType type) {
        if (null == type) {
            return Object.class;
        }
        switch (type) {
            case OBJECT: {
                return Object.class;
            }
            case MAP: {
                return LinkedHashMap.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case STRING: {
                return String.class;
            }
            case LIST: {
                return List.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    public void parseMapType(String prefix, Map<String, Object> map) {
        if (null == map) {
            return;
        }
        for (String key : map.keySet()) {
            Object val = map.get(key);
            FlatMapType myType = this.getType(val);
            String putKey = CommonUtil.isNullEmpty(prefix) ? key : prefix + "." + key;
            this.key2Type.put(putKey, myType);
            this._data_new.put(putKey, val);
            if (null == val) continue;
            switch (myType) {
                case OBJECT: 
                case MAP: {
                    this.parseMapType(putKey, (Map)val);
                    break;
                }
                case LIST: {
                    this.parseListType(putKey, (List)val);
                    break;
                }
            }
        }
    }

    public void parseListType(String prefix, List<Object> list) {
        if (null == list) {
            return;
        }
        this.key2Type.put(CommonUtil.isNullEmpty(prefix) ? "data" : prefix, FlatMapType.LIST);
        this._data_new.put(CommonUtil.isNullEmpty(prefix) ? "data" : prefix, list);
        int j = list.size();
        block4: for (int i = 0; i < j; ++i) {
            String putKey = CommonUtil.isNullEmpty(prefix) ? i + "" : prefix + "." + i;
            FlatMapType myType = this.getType(list.get(i));
            this.key2Type.put(putKey, myType);
            this._data_new.put(putKey, list.get(i));
            switch (myType) {
                case OBJECT: 
                case MAP: {
                    this.parseMapType(putKey, (Map)list.get(i));
                    continue block4;
                }
                case LIST: {
                    this.parseListType(putKey, (List)list.get(i));
                    continue block4;
                }
            }
        }
    }

    public Optional getOptional(String key) {
        Object val = this._data_new.get(key);
        return Optional.ofNullable(val);
    }

    public Object get(String key) {
        Object val = this._data_new.get(key);
        return val;
    }

    public String toString() {
        return "FlatMap{_data_new=" + this._data_new + ", key2Type=" + this.key2Type + '}';
    }

    public LinkedHashMap<String, Object> get_data_new() {
        return this._data_new;
    }

    public LinkedHashMap<String, FlatMapType> getKey2Type() {
        return this.key2Type;
    }
}

