/*
 * Decompiled with CFR 0.152.
 */
package xin.xihc.utils.htmltable;

import java.util.ArrayList;
import java.util.HashMap;
import xin.xihc.utils.common.CommonUtil;
import xin.xihc.utils.htmltable.Cell;
import xin.xihc.utils.htmltable.Row;
import xin.xihc.utils.htmltable.Table;

public class TableUtil {
    public static String convertToHtmlTable(Table table) {
        if (null == table) {
            return null;
        }
        long i = System.currentTimeMillis();
        TableUtil.addSumRows(table);
        long j = System.currentTimeMillis();
        System.err.println("\u626b\u63cf\u6dfb\u52a0\u5c0f\u8ba1\u8017\u65f6\uff1a" + (j - i) + "ms");
        TableUtil.computedAndFormat(table);
        long k = System.currentTimeMillis();
        System.err.println("\u8ba1\u7b97\u4ee5\u53ca\u683c\u5f0f\u5316\u8017\u65f6\uff1a" + (k - j) + "ms");
        TableUtil.mergeRow(table);
        long l = System.currentTimeMillis();
        System.err.println("\u5408\u5e76\u5355\u5143\u683c\u8017\u65f6\uff1a" + (l - k) + "ms");
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("<table border='").append(table.getBorder() + "' cellpadding='").append(table.getCellPadding() + "' cellspacing='").append(table.getCellSpacing() + "'");
            sb.append(" style='" + table.getStyle() + "'>");
            for (Row r : table.getHeader()) {
                sb.append("<tr");
                if (CommonUtil.isNotNullEmpty(r.getStyle())) {
                    sb.append(" style='" + r.getStyle() + "'");
                }
                sb.append(">");
                for (Cell c : r.getCells()) {
                    sb.append("<th");
                    if (CommonUtil.isNotNullEmpty(c.getStyle())) {
                        sb.append(" style='" + c.getStyle() + "'");
                    }
                    if (c.getRowSpan() > 1) {
                        sb.append(" rowspan='" + c.getRowSpan() + "'");
                    }
                    if (c.getColSpan() > 1) {
                        sb.append(" colspan='" + c.getColSpan() + "'");
                    }
                    sb.append(">");
                    sb.append(c.getValue());
                    sb.append("</th>");
                }
                sb.append("</tr>");
            }
            for (Row r : table.getData()) {
                sb.append("<tr");
                if (CommonUtil.isNotNullEmpty(r.getStyle())) {
                    sb.append(" style='" + r.getStyle() + "'");
                }
                sb.append(">");
                for (Cell c : r.getCells()) {
                    sb.append("<td");
                    if (CommonUtil.isNotNullEmpty(c.getStyle())) {
                        sb.append(" style='" + c.getStyle() + "'");
                    }
                    if (c.getRowSpan() > 1) {
                        sb.append(" rowspan='" + c.getRowSpan() + "'");
                    }
                    if (c.getColSpan() > 1) {
                        sb.append(" colspan='" + c.getColSpan() + "'");
                    }
                    sb.append(">");
                    sb.append(c.getValue());
                    sb.append("</td>");
                }
                sb.append("</tr>");
            }
            sb.append("</table>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private static void scanColumn(Table table, int colIndex, int rowStartIndex, int rowEndIndex) {
        if (!table.getIsSubTotal().booleanValue()) {
            return;
        }
        if (rowEndIndex < rowStartIndex || table.getData().size() - 1 < rowEndIndex) {
            return;
        }
        int colCount = table.getColumnCount();
        if (colIndex + 1 > colCount) {
            return;
        }
        if (!TableUtil.isAllowRowSpan(table, colIndex)) {
            return;
        }
        String temp = "";
        int iStart = 0;
        for (int i = rowEndIndex; i >= rowStartIndex; --i) {
            Row row = table.getData().get(i);
            String value = row.getCells().get(colIndex).getValue();
            value = CommonUtil.isNullEmpty(value) ? "" : value.replaceAll("<[^>]+>", "").trim();
            if (!temp.equals(value)) {
                int k;
                Cell c;
                Row row1;
                if (i == rowEndIndex) {
                    row1 = new Row();
                    row1.setStyle(table.getSubTotalStyle());
                    row1.setType(1);
                    row1.setTypeColIndex(colIndex);
                    for (int k2 = 0; k2 < colIndex; ++k2) {
                        row1.getCells().add(row.getCells().get(k2));
                    }
                    c = Cell.newInstance().setValue("\u5c0f\u8ba1");
                    row1.getCells().add(c);
                    for (k = colIndex + 1; k < colCount; ++k) {
                        c = Cell.newInstance().setValue("");
                        row1.getCells().add(c);
                    }
                    table.insertData(i + 1, row1);
                } else if (i < rowEndIndex) {
                    TableUtil.scanColumn(table, colIndex + 1, i + 1, iStart);
                    row1 = new Row();
                    row1.setStyle(table.getSubTotalStyle());
                    row1.setType(1);
                    row1.setTypeColIndex(colIndex);
                    for (int k3 = 0; k3 < colIndex; ++k3) {
                        row1.getCells().add(row.getCells().get(k3));
                    }
                    c = Cell.newInstance().setValue("\u5c0f\u8ba1");
                    row1.getCells().add(c);
                    for (k = colIndex + 1; k < colCount; ++k) {
                        c = Cell.newInstance().setValue("");
                        row1.getCells().add(c);
                    }
                    table.insertData(i + 1, row1);
                }
                temp = value;
                iStart = i;
            }
            if (i != rowStartIndex) continue;
            TableUtil.scanColumn(table, colIndex + 1, i, iStart);
        }
    }

    private static void addSumRows(Table table) {
        int i;
        int colCount = table.getColumnCount();
        int rowCount = table.getData().size();
        if (rowCount < 1) {
            return;
        }
        String temp = "";
        ArrayList<Integer> indexList = new ArrayList<Integer>(6);
        if (TableUtil.isAllowRowSpan(table, 0)) {
            for (i = 0; i < rowCount; ++i) {
                String value = table.getData().get(i).getCells().get(0).getValue();
                value = CommonUtil.isNullEmpty(value) ? "" : value.replaceAll("<[^>]+>", "").trim();
                if (temp.equals(value)) continue;
                temp = value;
                indexList.add(i);
            }
        } else {
            return;
        }
        indexList.add(rowCount);
        for (i = indexList.size() - 1; i > 0; --i) {
            TableUtil.scanColumn(table, 0, (Integer)indexList.get(i - 1), (Integer)indexList.get(i) - 1);
        }
        rowCount = table.getData().size();
        int iSt = 0;
        for (int i2 = colCount - 1; i2 >= 0; --i2) {
            if (!TableUtil.isAllowRowSpan(table, i2)) continue;
            temp = table.getData().get(0).getCells().get(i2).getValue();
            temp = CommonUtil.isNullEmpty(temp) ? "" : temp.replaceAll("<[^>]+>", "").trim();
            iSt = 0;
            for (int j = 0; j < rowCount; ++j) {
                String value = table.getData().get(j).getCells().get(i2).getValue();
                value = CommonUtil.isNullEmpty(value) ? "" : value.replaceAll("<[^>]+>", "").trim();
                if (temp.equals(value) && !"".equals(value)) {
                    table.getData().get(iSt).getCells().get(i2).setRowSpan(j - iSt + 1);
                    continue;
                }
                temp = value;
                iSt = j;
            }
        }
    }

    private static void computedAndFormat(Table table) {
        int r;
        int colCount = table.getColumnCount();
        int rowCount = table.getData().size();
        if (table.getIsRowTotal().booleanValue()) {
            if (table.getHeader().size() == 1) {
                Cell e = Cell.newInstance();
                e.setValue("\u5408\u8ba1");
                e.setStyle(table.getRowTotalStyle());
                table.getHeader().get(0).getCells().add(e);
            } else if (table.getHeader().get(0).getCells().get(0).getColSpan().intValue() == table.getColumnCount()) {
                table.getHeader().get(0).getCells().get(0).setColSpan(colCount + 1);
                for (int k = 1; k < table.getHeader().size(); ++k) {
                    Cell e = Cell.newInstance();
                    e.setValue("\u5408\u8ba1");
                    e.setStyle(table.getRowTotalStyle());
                    table.getHeader().get(k).getCells().add(e);
                }
            }
        }
        if (table.getIsTotal().booleanValue()) {
            Row row1 = new Row();
            row1.setStyle(table.getTotalStyle());
            row1.setType(2);
            row1.setTypeColIndex(0);
            Cell c = Cell.newInstance().setValue("\u5408\u8ba1");
            row1.getCells().add(c);
            for (int k = 1; k < colCount; ++k) {
                c = Cell.newInstance().setValue("");
                row1.getCells().add(c);
            }
            table.insertData(rowCount, row1);
        }
        HashMap<String, Double> total = new HashMap<String, Double>(colCount * 2 + rowCount);
        rowCount = table.getData().size();
        for (r = 0; r < rowCount; ++r) {
            if (total.containsKey("row" + r)) continue;
            total.put("row" + r, 0.0);
        }
        for (int c = 0; c < colCount; ++c) {
            if (!TableUtil.isSum(table, c)) continue;
            for (int i = 0; i <= c; ++i) {
                total.put("col_sub" + i, 0.0);
            }
            block12: for (int r2 = 0; r2 < rowCount; ++r2) {
                String value;
                Row row = table.getData().get(r2);
                if (!total.containsKey("col" + c)) {
                    total.put("col" + c, 0.0);
                }
                value = CommonUtil.isNullEmpty(value = row.getCells().get(c).getValue()) ? "0" : value.replaceAll("<[^>]+>", "").trim();
                double val = 0.0;
                try {
                    val = Double.valueOf(value);
                }
                catch (Exception e) {
                    val = 0.0;
                }
                switch (row.getType()) {
                    case 0: {
                        total.put("row" + r2, val + (Double)total.get("row" + r2));
                        total.put("col" + c, val + (Double)total.get("col" + c));
                        for (int i = 0; i <= c; ++i) {
                            total.put("col_sub" + i, val + (Double)total.get("col_sub" + i));
                        }
                        row.getCells().get(c).setValue(TableUtil.formatNum(table, val));
                        continue block12;
                    }
                    case 1: {
                        row.getCells().get(c).setValue(TableUtil.formatNum(table, (Double)total.get("col_sub" + row.getTypeColIndex())));
                        total.put("row" + r2, (Double)total.get("col_sub" + row.getTypeColIndex()) + (Double)total.get("row" + r2));
                        total.put("col_sub" + row.getTypeColIndex(), 0.0);
                        continue block12;
                    }
                    case 2: {
                        total.put("row" + r2, (Double)total.get("col" + c) + (Double)total.get("row" + r2));
                        row.getCells().get(c).setValue(TableUtil.formatNum(table, (Double)total.get("col" + c)));
                        continue block12;
                    }
                }
            }
        }
        if (table.getIsRowTotal().booleanValue()) {
            for (r = 0; r < rowCount; ++r) {
                Row row = table.getData().get(r);
                Cell e = Cell.newInstance().setValue(TableUtil.formatNum(table, (Double)total.get("row" + r)));
                row.getCells().add(e);
            }
        }
    }

    private static Table mergeRow(Table table) {
        int colCount = table.getColumnCount();
        int rowCount = table.getData().size();
        for (int i = colCount - 1; i >= 0; --i) {
            Boolean isAllowRowSpan = table.getHeader().get(table.getHeader().size() - 1).getCells().get(i).getIsAllowRowSpan();
            if (!isAllowRowSpan.booleanValue()) continue;
            for (int j = 0; j < rowCount; ++j) {
                Integer rowSpan = table.getData().get(j).getCells().get(i).getRowSpan();
                if (rowSpan < 2) continue;
                for (int k = j + 1; k < j + rowSpan; ++k) {
                    table.getData().get(k).getCells().remove(i);
                }
                j += rowSpan - 1;
            }
        }
        return table;
    }

    private static boolean isAllowRowSpan(Table table, int colIndex) {
        boolean res = false;
        for (int i = 0; i < table.getHeader().size(); ++i) {
            res = table.getHeader().get(i).getCells().size() - 1 < colIndex ? false : res || table.getHeader().get(i).getCells().get(colIndex).getIsAllowRowSpan() != false;
        }
        return res;
    }

    private static boolean isSum(Table table, int colIndex) {
        boolean res = false;
        for (int i = 0; i < table.getHeader().size(); ++i) {
            res = table.getHeader().get(i).getCells().size() - 1 < colIndex ? false : res || table.getHeader().get(i).getCells().get(colIndex).getIsSum() != false;
        }
        return res;
    }

    private static String formatNum(Table tab, double val) {
        String res = String.format("%." + tab.getNumDecimalCount() + "f", val);
        if (CommonUtil.isNotNullEmpty(tab.getNumPrefix())) {
            res = tab.getNumPrefix() + res;
        }
        if (CommonUtil.isNotNullEmpty(tab.getNumSuffix())) {
            res = res + tab.getNumSuffix();
        }
        return res;
    }
}

