/*
 * Decompiled with CFR 0.152.
 */
package xin.xihc.utils.json;

public final class JsonFormat {
    public static String format(String jsonStr) {
        if (null == jsonStr || "".equals(jsonStr)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char last = '\u0000';
        char current = '\u0000';
        int indent = 0;
        boolean isInQuotationMarks = false;
        block6: for (int i = 0; i < jsonStr.length(); ++i) {
            last = current;
            current = jsonStr.charAt(i);
            switch (current) {
                case '\"': {
                    if (last != '\\') {
                        isInQuotationMarks = !isInQuotationMarks;
                    }
                    sb.append(current);
                    continue block6;
                }
                case '[': 
                case '{': {
                    sb.append(current);
                    if (isInQuotationMarks) continue block6;
                    sb.append('\n');
                    JsonFormat.addIndentBlank(sb, ++indent);
                    continue block6;
                }
                case ']': 
                case '}': {
                    if (!isInQuotationMarks) {
                        sb.append('\n');
                        JsonFormat.addIndentBlank(sb, --indent);
                    }
                    sb.append(current);
                    continue block6;
                }
                case ',': {
                    sb.append(current);
                    if (last == '\\' || isInQuotationMarks) continue block6;
                    sb.append('\n');
                    JsonFormat.addIndentBlank(sb, indent);
                    continue block6;
                }
                default: {
                    if (!isInQuotationMarks) {
                        String ss = String.valueOf(current).replaceAll("\\s", "");
                        sb.append(ss);
                        continue block6;
                    }
                    sb.append(current);
                }
            }
        }
        return sb.toString();
    }

    private static void addIndentBlank(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append('\t');
        }
    }
}

