/*
 * Decompiled with CFR 0.152.
 */
package xin.xihc.utils.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import xin.xihc.utils.common.CommonUtil;
import xin.xihc.utils.log.LogUtil;

public final class JsonUtil {
    private static Logger LOG = LogUtil.getLogger(JsonUtil.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private static ObjectMapper nonNullMapper;

    private JsonUtil() {
    }

    public static ObjectMapper newObjectMapper() {
        return nonNullMapper.copy();
    }

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    public static <T> T readValue(String content, Class<T> valueType) {
        if (CommonUtil.isNullEmpty(content)) {
            return null;
        }
        try {
            return (T)mapper.readValue(content, valueType);
        }
        catch (Exception e) {
            LOG.error("JsonUtil.readValue() Exception at " + CommonUtil.getStackTrace(1), (Throwable)e);
            return null;
        }
    }

    public static <T> T readValue(String content, TypeReference<T> valueTypeRef) {
        if (CommonUtil.isNullEmpty(content)) {
            return null;
        }
        try {
            return (T)mapper.readValue(content, valueTypeRef);
        }
        catch (Exception e) {
            LOG.error("JsonUtil.readValue() Exception at " + CommonUtil.getStackTrace(1), (Throwable)e);
            return null;
        }
    }

    public static <T> T convertValue(Object obj, Class<T> valueType) {
        if (null == obj) {
            return null;
        }
        try {
            return (T)mapper.convertValue(obj, valueType);
        }
        catch (Exception e) {
            LOG.error("JsonUtil.convertValue() Exception at " + CommonUtil.getStackTrace(1), (Throwable)e);
            return null;
        }
    }

    public static <T> T convertValue(Object obj, TypeReference<T> valueTypeRef) {
        if (null == obj) {
            return null;
        }
        try {
            return (T)mapper.convertValue(obj, valueTypeRef);
        }
        catch (Exception e) {
            LOG.error("JsonUtil.convertValue() Exception at " + CommonUtil.getStackTrace(1), (Throwable)e);
            return null;
        }
    }

    public static String toJsonString(Object obj, boolean pretty) {
        if (null == obj) {
            return null;
        }
        try {
            String jsonStr = null;
            jsonStr = pretty ? mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj) : mapper.writeValueAsString(obj);
            return jsonStr;
        }
        catch (Exception e) {
            LOG.error("JsonUtil.toJsonString() Exception at " + CommonUtil.getStackTrace(1), (Throwable)e);
            return null;
        }
    }

    public static String toNoNullJsonStr(Object obj, boolean pretty) {
        if (null == obj) {
            return null;
        }
        try {
            String jsonStr = null;
            jsonStr = pretty ? nonNullMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj) : nonNullMapper.writeValueAsString(obj);
            return jsonStr;
        }
        catch (Exception e) {
            LOG.error("JsonUtil.toNoNullJsonStr() Exception at " + CommonUtil.getStackTrace(1), (Throwable)e);
            return null;
        }
    }

    static {
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        nonNullMapper = mapper.copy();
        nonNullMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

