/*
 * Decompiled with CFR 0.152.
 */
package xin.xihc.utils.log;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedRollingPolicy;
import ch.qos.logback.core.util.FileSize;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.xihc.utils.common.ScheduleUtils;

public class LogUtil {
    public static final String SCHEDULE_NAME = "LOG_0_0_INIT_FILE_APPENDER";
    private static final String CONSOLE_APPENDER_NAME = "logToConsole";
    public static int MAX_HISTORY = 60;
    public static String MAX_FILE_SIZE = "10MB";
    public static String TOTAL_SIZE = "20GB";
    public static String LOG_DIR = "./logs/%d{yyyyMM}/%d{dd}";
    public static String LOG_MSG_PATTERN = "%d{yyyy-MM-dd HH:mm:ss.SSS} [%thread] %-5level %class::[%method:%L] %n%msg%n%n";
    private static boolean TO_CONSOLE = true;
    private static LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
    private static LinkedList<ch.qos.logback.classic.Logger> LOGS = new LinkedList();
    private static LinkedHashMap<String, RollingFileAppender<ILoggingEvent>> APPENDER = new LinkedHashMap();

    public static synchronized void initFileAppender() {
        System.err.println("\u5f00\u59cb\u91cd\u65b0\u8bbe\u7f6e\u6587\u4ef6\u8def\u5f84" + new Date().toString());
        String[] names = APPENDER.keySet().toArray(new String[0]);
        APPENDER.clear();
        for (String k : names) {
            RollingFileAppender<ILoggingEvent> appender = LogUtil.getFileAppender(k);
            APPENDER.put(k, appender);
            LOGS.forEach(l -> {
                Appender old = l.getAppender(k);
                if (old != null) {
                    l.detachAndStopAllAppenders();
                    l.addAppender((Appender)appender);
                    appender.start();
                }
            });
        }
        LogUtil.setToConsole(TO_CONSOLE);
    }

    public static synchronized void resetRoot() {
        ch.qos.logback.classic.Logger root = loggerContext.getLogger("ROOT");
        root.detachAndStopAllAppenders();
        root.addAppender(LogUtil.getConsoleAppender());
    }

    public static Logger getLogger(Class<?> clazz) {
        return LogUtil.getLogger(clazz.getName(), null);
    }

    public static Logger getLogger(Class<?> clazz, String logFileName) {
        return LogUtil.getLogger(clazz.getName(), logFileName);
    }

    public static Logger getLogger(String logFileName) {
        if (null == logFileName || "".equals(logFileName.trim())) {
            logFileName = "info";
        }
        return LogUtil.getLogger("log." + logFileName, logFileName);
    }

    public static synchronized Logger getLogger(String logName, String logFileName) {
        if (null == logFileName || "".equals(logFileName.trim())) {
            logFileName = "info";
        }
        ch.qos.logback.classic.Logger newLog = loggerContext.getLogger(logName);
        logFileName = "log-" + logFileName;
        LOGS.add(newLog);
        newLog.detachAndStopAllAppenders();
        newLog.addAppender(LogUtil.getFileAppender(logFileName));
        newLog.setAdditive(false);
        if (TO_CONSOLE) {
            newLog.setAdditive(true);
        }
        if (!ScheduleUtils.existsTask(SCHEDULE_NAME)) {
            ScheduleUtils.putTask(SCHEDULE_NAME, "1 0 0 * * *", LogUtil::initFileAppender);
        }
        return newLog;
    }

    private static RollingFileAppender<ILoggingEvent> getFileAppender(String logFileName) {
        return APPENDER.computeIfAbsent(logFileName, k -> {
            RollingFileAppender fileAppender = new RollingFileAppender();
            SizeAndTimeBasedRollingPolicy policy = new SizeAndTimeBasedRollingPolicy();
            policy.setContext((Context)loggerContext);
            policy.setMaxHistory(MAX_HISTORY);
            policy.setTotalSizeCap(FileSize.valueOf((String)TOTAL_SIZE));
            policy.setFileNamePattern(LOG_DIR + "/" + logFileName + ".%i.log");
            policy.setParent((FileAppender)fileAppender);
            policy.setMaxFileSize(FileSize.valueOf((String)MAX_FILE_SIZE));
            policy.start();
            PatternLayout layout = new PatternLayout();
            layout.setContext((Context)loggerContext);
            layout.setPattern(LOG_MSG_PATTERN);
            layout.start();
            fileAppender.setRollingPolicy((RollingPolicy)policy);
            fileAppender.setName(logFileName);
            fileAppender.setContext((Context)loggerContext);
            fileAppender.setLayout((Layout)layout);
            fileAppender.setPrudent(true);
            fileAppender.start();
            return fileAppender;
        });
    }

    private static ConsoleAppender<ILoggingEvent> getConsoleAppender() {
        ConsoleAppender consoleAppender = new ConsoleAppender();
        PatternLayout layout = new PatternLayout();
        layout.setContext((Context)loggerContext);
        layout.setPattern(LOG_MSG_PATTERN);
        layout.start();
        consoleAppender.setContext((Context)loggerContext);
        consoleAppender.setLayout((Layout)layout);
        consoleAppender.setName(CONSOLE_APPENDER_NAME);
        consoleAppender.start();
        return consoleAppender;
    }

    public static synchronized void setToConsole(boolean toConsole) {
        TO_CONSOLE = toConsole;
        for (ch.qos.logback.classic.Logger log : LOGS) {
            if (toConsole) {
                log.setAdditive(true);
                continue;
            }
            log.setAdditive(false);
        }
    }

    static {
        LogUtil.resetRoot();
    }
}

