/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.Constants;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.EncryptionConstants;
import org.apache.xml.security.utils.HelperNodeList;
import org.apache.xml.security.utils.I18n;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtils {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$utils$XMLUtils == null ? (class$org$apache$xml$security$utils$XMLUtils = XMLUtils.class$("org.apache.xml.security.utils.XMLUtils")) : class$org$apache$xml$security$utils$XMLUtils).getName());
    private static String[] nodeTypeString = new String[]{"", "ELEMENT", "ATTRIBUTE", "TEXT_NODE", "CDATA_SECTION", "ENTITY_REFERENCE", "ENTITY", "PROCESSING_INSTRUCTION", "COMMENT", "DOCUMENT", "DOCUMENT_TYPE", "DOCUMENT_FRAGMENT", "NOTATION"};
    private static String randomNS = null;
    public static final String randomNSprefix = "http://www.xmlsecurity.org/NS#randomval";
    static /* synthetic */ Class class$org$apache$xml$security$utils$XMLUtils;
    static /* synthetic */ Class class$java$lang$Thread;

    private XMLUtils() {
    }

    public static String getXalanVersion() {
        String string = XMLUtils.getXalan1Version();
        if (string != null) {
            return string;
        }
        string = XMLUtils.getXalan20Version();
        if (string != null) {
            return string;
        }
        string = XMLUtils.getXalan2Version();
        if (string != null) {
            return string;
        }
        return "Apache Xalan not installed";
    }

    public static String getXercesVersion() {
        String string = XMLUtils.getXerces1Version();
        if (string != null) {
            return string;
        }
        string = XMLUtils.getXerces2Version();
        if (string != null) {
            return string;
        }
        return "Apache Xerces not installed";
    }

    private static String getXalan1Version() {
        try {
            Class clazz = XMLUtils.classForName("org.apache.xalan.xslt.XSLProcessorVersion");
            StringBuffer stringBuffer = new StringBuffer();
            Field field = clazz.getField("PRODUCT");
            stringBuffer.append(field.get(null));
            stringBuffer.append(';');
            field = clazz.getField("LANGUAGE");
            stringBuffer.append(field.get(null));
            stringBuffer.append(';');
            field = clazz.getField("S_VERSION");
            stringBuffer.append(field.get(null));
            stringBuffer.append(';');
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getXalan20Version() {
        try {
            Class[] classArray = new Class[]{};
            Class clazz = XMLUtils.classForName("org.apache.xalan.Version");
            Method method = clazz.getMethod("getVersion", classArray);
            Object object = method.invoke(null, new Object[0]);
            return (String)object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getXalan2Version() {
        try {
            Class clazz = XMLUtils.classForName("org.apache.xalan.processor.XSLProcessorVersion");
            StringBuffer stringBuffer = new StringBuffer();
            Field field = clazz.getField("S_VERSION");
            stringBuffer.append(field.get(null));
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getXerces1Version() {
        try {
            Class clazz = XMLUtils.classForName("org.apache.xerces.framework.Version");
            Field field = clazz.getField("fVersion");
            String string = (String)field.get(null);
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getXerces2Version() {
        try {
            Class clazz = XMLUtils.classForName("org.apache.xerces.impl.Version");
            Field field = clazz.getField("fVersion");
            String string = (String)field.get(null);
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static Class classForName(String string) throws ClassNotFoundException {
        ClassLoader classLoader = XMLUtils.findClassLoader();
        if (classLoader == null) {
            return Class.forName(string);
        }
        return classLoader.loadClass(string);
    }

    protected static ClassLoader findClassLoader() throws ClassNotFoundException {
        Method method = null;
        try {
            method = (class$java$lang$Thread == null ? (class$java$lang$Thread = XMLUtils.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return (class$org$apache$xml$security$utils$XMLUtils == null ? (class$org$apache$xml$security$utils$XMLUtils = XMLUtils.class$("org.apache.xml.security.utils.XMLUtils")) : class$org$apache$xml$security$utils$XMLUtils).getClassLoader();
        }
        try {
            return (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public static void spitOutVersions(Log log) {
        log.debug((Object)XMLUtils.getXercesVersion());
        log.debug((Object)XMLUtils.getXalanVersion());
    }

    public static String getNodeTypeString(short s) {
        if (s > 0 && s < 13) {
            return nodeTypeString[s];
        }
        return "";
    }

    public static String getNodeTypeString(Node node) {
        return XMLUtils.getNodeTypeString(node.getNodeType());
    }

    public static Vector getAncestorElements(Node node) {
        if (node.getNodeType() != 1) {
            return null;
        }
        Vector<Node> vector = new Vector<Node>();
        Node node2 = node;
        while ((node2 = node2.getParentNode()) != null && node2.getNodeType() == 1) {
            vector.add(node2);
        }
        vector.trimToSize();
        return vector;
    }

    public static Vector getAncestorElements(Node node, Node node2) {
        Vector<Node> vector = new Vector<Node>();
        if (node.getNodeType() != 1) {
            return vector;
        }
        Node node3 = node;
        Node node4 = node2.getParentNode();
        while ((node3 = node3.getParentNode()) != null && node3.getNodeType() == 1 && node3 != node4) {
            vector.add(node3);
        }
        vector.trimToSize();
        return vector;
    }

    public static NodeList getDirectChildrenElements(Element element) {
        NodeList nodeList = element.getChildNodes();
        HelperNodeList helperNodeList = new HelperNodeList();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            helperNodeList.appendChild(node);
        }
        return helperNodeList;
    }

    public static Element getDirectChild(Element element, String string, String string2) {
        NodeList nodeList = element.getChildNodes();
        Vector<Node> vector = new Vector<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !((Element)node).getLocalName().equals(string) || !((Element)node).getNamespaceURI().equals(string2)) continue;
            vector.add(node);
        }
        if (vector.size() != 1) {
            return null;
        }
        return (Element)vector.elementAt(0);
    }

    public static void outputDOM(Node node, String string) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        XMLUtils.outputDOM(node, fileOutputStream);
    }

    public static void outputDOM(Node node, OutputStream outputStream) {
        XMLUtils.outputDOM(node, outputStream, false);
    }

    public static void outputDOM(Node node, OutputStream outputStream, boolean bl) {
        try {
            if (bl) {
                outputStream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes());
            }
            outputStream.write(Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments").canonicalizeSubtree(node));
        }
        catch (IOException iOException) {
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            invalidCanonicalizerException.printStackTrace();
        }
        catch (CanonicalizationException canonicalizationException) {
            canonicalizationException.printStackTrace();
        }
    }

    public static void outputDOMc14nWithComments(Node node, OutputStream outputStream) {
        try {
            outputStream.write(Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments").canonicalizeSubtree(node));
        }
        catch (IOException iOException) {
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
        }
        catch (CanonicalizationException canonicalizationException) {
            // empty catch block
        }
    }

    public static NodeList elementToNodeList(Node node) {
        HelperNodeList helperNodeList = new HelperNodeList();
        helperNodeList.appendChild(node);
        return helperNodeList;
    }

    public static Attr createAttr(Document document, String string, String string2, String string3) {
        Attr attr = document.createAttributeNS(string3, string);
        attr.setNodeValue(string2);
        return attr;
    }

    public static void setAttr(Element element, String string, String string2) {
        Document document = element.getOwnerDocument();
        Attr attr = document.createAttributeNS("http://www.w3.org/2000/09/xmldsig#", string);
        attr.setNodeValue(string2);
        element.setAttributeNode(attr);
    }

    public static Element createElementFromBigint(Document document, String string, BigInteger bigInteger) throws XMLSignatureException {
        Object object;
        Element element = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", Constants.getSignatureSpecNSprefix() + ":" + string);
        if (bigInteger.signum() != 1) {
            throw new XMLSignatureException("signature.Util.BignumNonPositive");
        }
        byte[] byArray = bigInteger.toByteArray();
        while (byArray[0] == 0) {
            object = byArray;
            byArray = new byte[((byte[])object).length - 1];
            System.arraycopy(object, 1, byArray, 0, ((byte[])object).length - 1);
        }
        object = document.createTextNode(Base64.encode(byArray));
        element.appendChild((Node)object);
        return element;
    }

    public static String getFullTextChildrenFromElement(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            stringBuffer.append(((Text)node).getData());
        }
        return stringBuffer.toString();
    }

    public static BigInteger getBigintFromElement(Element element) throws XMLSignatureException {
        try {
            if (element.getChildNodes().getLength() != 1) {
                throw new XMLSignatureException("signature.Util.TooManyChilds");
            }
            Node node = element.getFirstChild();
            if (node == null || node.getNodeType() != 3) {
                throw new XMLSignatureException("signature.Util.NonTextNode");
            }
            Text text = (Text)node;
            String string = text.getData();
            byte[] byArray = Base64.decode(string);
            int n = 1;
            BigInteger bigInteger = new BigInteger(n, byArray);
            return bigInteger;
        }
        catch (Base64DecodingException base64DecodingException) {
            throw new XMLSignatureException("empty", base64DecodingException);
        }
    }

    public static byte[] getBytesFromElement(Element element) throws XMLSignatureException {
        try {
            if (element.getChildNodes().getLength() != 1) {
                throw new XMLSignatureException("signature.Util.TooManyChilds");
            }
            Node node = element.getFirstChild();
            if (node == null || node.getNodeType() != 3) {
                throw new XMLSignatureException("signature.Util.NonTextNode");
            }
            Text text = (Text)node;
            String string = text.getData();
            byte[] byArray = Base64.decode(string);
            return byArray;
        }
        catch (Base64DecodingException base64DecodingException) {
            throw new XMLSignatureException("empty", base64DecodingException);
        }
    }

    public static Element createElementInSignatureSpace(Document document, String string) {
        if (document == null) {
            throw new RuntimeException("Document is null");
        }
        String string2 = Constants.getSignatureSpecNSprefix();
        if (string2 == null || string2.length() == 0) {
            Element element = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", string);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
            return element;
        }
        Element element = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", string2 + ":" + string);
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string2, "http://www.w3.org/2000/09/xmldsig#");
        return element;
    }

    public static Element createElementInEncryptionSpace(Document document, String string) {
        if (document == null) {
            throw new RuntimeException("Document is null");
        }
        String string2 = EncryptionConstants.getEncryptionSpecNSprefix();
        if (string2 == null || string2.length() == 0) {
            Element element = document.createElementNS("http://www.w3.org/2001/04/xmlenc#", string);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
            return element;
        }
        Element element = document.createElementNS("http://www.w3.org/2001/04/xmlenc#", string2 + ":" + string);
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string2, "http://www.w3.org/2001/04/xmlenc#");
        return element;
    }

    public static boolean elementIsInSignatureSpace(Element element, String string) {
        if (element == null) {
            return false;
        }
        if (element.getNamespaceURI() == null) {
            return false;
        }
        if (!element.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) {
            return false;
        }
        return element.getLocalName().equals(string);
    }

    public static boolean elementIsInEncryptionSpace(Element element, String string) {
        if (element == null) {
            return false;
        }
        if (element.getNamespaceURI() == null) {
            return false;
        }
        if (!element.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#")) {
            return false;
        }
        return element.getLocalName().equals(string);
    }

    public static void guaranteeThatElementInSignatureSpace(Element element, String string) throws XMLSignatureException {
        if (element == null) {
            Object[] objectArray = new Object[]{string, null};
            throw new XMLSignatureException("xml.WrongElement", objectArray);
        }
        if (string == null || string.equals("") || !XMLUtils.elementIsInSignatureSpace(element, string)) {
            Object[] objectArray = new Object[]{string, element.getLocalName()};
            throw new XMLSignatureException("xml.WrongElement", objectArray);
        }
    }

    public static void guaranteeThatElementInEncryptionSpace(Element element, String string) throws XMLSecurityException {
        if (element == null) {
            Object[] objectArray = new Object[]{string, null};
            throw new XMLSecurityException("xml.WrongElement", objectArray);
        }
        if (string == null || string.equals("") || !XMLUtils.elementIsInEncryptionSpace(element, string)) {
            Object[] objectArray = new Object[]{string, element.getLocalName()};
            throw new XMLSecurityException("xml.WrongElement", objectArray);
        }
    }

    public static Document getOwnerDocument(Node node) {
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        try {
            return node.getOwnerDocument();
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException(I18n.translate("endorsed.jdk1.4.0") + " Original message was \"" + nullPointerException.getMessage() + "\"");
        }
    }

    public static Document getOwnerDocument(Set set) {
        NullPointerException nullPointerException = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.getNodeType() == 9) {
                return (Document)node;
            }
            try {
                return node.getOwnerDocument();
            }
            catch (NullPointerException nullPointerException2) {
                nullPointerException = nullPointerException2;
            }
        }
        throw new NullPointerException(I18n.translate("endorsed.jdk1.4.0") + " Original message was \"" + (nullPointerException == null ? "" : nullPointerException.getMessage()) + "\"");
    }

    public static String getRandomNamespacePrefix() {
        if (randomNS == null) {
            byte[] byArray = new byte[21];
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(byArray);
            String string = "xmlsecurityOrgPref" + Base64.encode(byArray);
            randomNS = "";
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '+' || string.charAt(i) == '/' || string.charAt(i) == '=') continue;
                randomNS = randomNS + string.charAt(i);
            }
        }
        return randomNS;
    }

    public static Element createDSctx(Document document, String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("You must supply a prefix");
        }
        Element element = document.createElementNS(null, "namespaceContext");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string.trim(), string2);
        return element;
    }

    public static Element createDSctx(Document document, String string) {
        return XMLUtils.createDSctx(document, string, "http://www.w3.org/2000/09/xmldsig#");
    }

    public static void addReturnToElement(ElementProxy elementProxy) {
        Document document = elementProxy._doc;
        elementProxy.getElement().appendChild(document.createTextNode("\n"));
    }

    public static void addReturnToElement(Element element) {
        Document document = element.getOwnerDocument();
        element.appendChild(document.createTextNode("\n"));
    }

    public static void addReturnToNode(Node node) {
        Document document = node.getOwnerDocument();
        node.appendChild(document.createTextNode("\n"));
    }

    public static Set convertNodelistToSet(NodeList nodeList) {
        if (nodeList == null) {
            return new HashSet();
        }
        int n = nodeList.getLength();
        HashSet<Node> hashSet = new HashSet<Node>(n);
        for (int i = 0; i < n; ++i) {
            hashSet.add(nodeList.item(i));
        }
        return hashSet;
    }

    public static NodeList convertSetToNodelist(Set set) {
        HelperNodeList helperNodeList = new HelperNodeList();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            helperNodeList.appendChild((Node)iterator.next());
        }
        return helperNodeList;
    }

    public static void circumventBug2650(Document document) {
        Element element = document.getDocumentElement();
        Attr attr = element.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        if (attr == null) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        }
        XMLUtils.circumventBug2650recurse(document);
    }

    private static void circumventBug2650recurse(Node node) {
        Node node2;
        if (node.getNodeType() == 1) {
            node2 = (Element)node;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            int n = namedNodeMap.getLength();
            NodeList nodeList = node2.getChildNodes();
            int n2 = nodeList.getLength();
            for (int i = 0; i < n2; ++i) {
                Node node3 = nodeList.item(i);
                if (node3.getNodeType() != 1) continue;
                Element element = (Element)node3;
                for (int j = 0; j < n; ++j) {
                    boolean bl;
                    Attr attr = (Attr)namedNodeMap.item(j);
                    boolean bl2 = "http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI());
                    if (!bl2) continue;
                    boolean bl3 = bl = !element.hasAttributeNS("http://www.w3.org/2000/xmlns/", attr.getLocalName());
                    if (!bl) continue;
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", attr.getName(), attr.getNodeValue());
                }
            }
        }
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getNodeType()) {
                case 1: 
                case 5: 
                case 9: {
                    XMLUtils.circumventBug2650recurse(node2);
                }
            }
        }
    }

    private static String getXPath(Node node, String string) {
        if (node == null) {
            return string;
        }
        switch (node.getNodeType()) {
            case 2: {
                return XMLUtils.getXPath(((Attr)node).getOwnerElement(), "/@" + ((Attr)node).getNodeName() + "=\"" + ((Attr)node).getNodeValue() + "\"");
            }
            case 1: {
                return XMLUtils.getXPath(node.getParentNode(), "/" + ((Element)node).getTagName() + string);
            }
            case 3: {
                return XMLUtils.getXPath(node.getParentNode(), "/#text");
            }
            case 9: {
                if (string.length() > 0) {
                    return string;
                }
                return "/";
            }
        }
        return string;
    }

    public static String getXPath(Node node) {
        return XMLUtils.getXPath(node, "");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

