/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.xupdate.lexus;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserAdapter;
import org.xmldb.common.xml.queries.XUpdateQuery;
import org.xmldb.xupdate.lexus.XUpdateQueryParser;
import org.xmldb.xupdate.lexus.commands.CommandConstants;
import org.xmldb.xupdate.lexus.commands.CommandObject;
import org.xmldb.xupdate.lexus.commands.DefaultCommand;

public class XUpdateQueryImpl
implements XUpdateQuery {
    public static final String NAMESPACE_URI = "http://www.xmldb.org/xupdate";
    protected Vector[] _query = null;
    protected CommandConstants _commands = new CommandConstants();
    protected NodeFilter _filter = null;
    protected Node _namespace = null;
    protected HashMap _namespaces = null;

    public void setQString(String query) throws SAXException {
        XUpdateQueryParser xuParser = new XUpdateQueryParser(this._commands);
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            ParserAdapter saxParser = new ParserAdapter(parser.getParser());
            saxParser.setContentHandler(xuParser);
            saxParser.parse(new InputSource(new StringReader(query)));
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
        this._namespaces = xuParser.getNamespaceMappings();
        this._query = xuParser.getCachedQuery();
        if (this._query[0].size() == 0) {
            throw new SAXException("query contains no XUpdateOperation !");
        }
    }

    public void setNamespace(Node node) {
        this._namespace = node;
    }

    public void setNodeFilter(NodeFilter filter) {
        this._filter = filter;
    }

    public void execute(Node contextNode) throws Exception {
        CommandObject currentCommand = new DefaultCommand(contextNode);
        Enumeration commands = this._query[0].elements();
        Enumeration attributes = this._query[1].elements();
        Enumeration characters = this._query[2].elements();
        block4: while (commands.hasMoreElements()) {
            int id = (Integer)commands.nextElement();
            if (id > 0) {
                switch (id) {
                    case 200: {
                        currentCommand.submitAttributes((Hashtable)attributes.nextElement());
                        break;
                    }
                    case 300: {
                        currentCommand.submitCharacters((String)characters.nextElement());
                        break;
                    }
                    default: {
                        if (currentCommand.submitInstruction(id)) continue block4;
                        this._commands.setContextNode(contextNode);
                        currentCommand = this._commands.commandForID(id);
                        if (currentCommand == null) {
                            throw new Exception("operation can not have any XUpdate-instruction !");
                        }
                        currentCommand.reset();
                        break;
                    }
                }
                continue;
            }
            if (currentCommand.executeInstruction()) continue;
            contextNode = currentCommand.execute();
            currentCommand = new DefaultCommand(contextNode);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("usage: java org.xmldb.xupdate.lexus.XUpdateQueryImpl update document");
            System.err.println("       update   - filename of the file which contains XUpdate operations");
            System.err.println("       document - filename of the file which contains the content to update");
            System.exit(0);
        }
        File file = new File(args[0]);
        BufferedReader br = new BufferedReader(new FileReader(file));
        char[] characters = new char[new Long(file.length()).intValue()];
        br.read(characters, 0, new Long(file.length()).intValue());
        String queryStr = new String(characters);
        Document myDocument = null;
        DocumentBuilderFactory parserFactory = DocumentBuilderFactory.newInstance();
        parserFactory.setValidating(false);
        parserFactory.setNamespaceAware(true);
        parserFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = parserFactory.newDocumentBuilder();
        myDocument = builder.parse(args[1]);
        System.setProperty("org.xmldb.common.xml.queries.XPathQueryFactory", "org.xmldb.common.xml.queries.xalan2.XPathQueryFactoryImpl");
        XUpdateQueryImpl xq = new XUpdateQueryImpl();
        System.err.println("Starting updates...");
        long timeStart = System.currentTimeMillis();
        xq.setQString(queryStr);
        xq.execute(myDocument);
        long timeEnd = System.currentTimeMillis();
        System.err.println("Updates done in " + (timeEnd - timeStart) + " ms ...");
    }

    static {
        NAMESPACE_URI = NAMESPACE_URI;
    }
}

