/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.xupdate.lexus;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xmldb.xupdate.lexus.commands.CommandConstants;

public class XUpdateQueryParser
implements ContentHandler {
    protected Vector _commands = null;
    protected Vector _attributes = null;
    protected Vector _characters = null;
    protected HashMap _namespaces = null;
    protected CommandConstants _consts = null;
    protected boolean _xupdateInsertOperation = false;
    protected String _lastOperation = "";

    public XUpdateQueryParser(CommandConstants constants) {
        this._consts = constants;
        this._commands = new Vector();
        this._attributes = new Vector();
        this._characters = new Vector();
        this._namespaces = new HashMap();
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        int i = 0;
        while (i < atts.getLength()) {
            attributes.put(atts.getLocalName(i), atts.getValue(i));
            ++i;
        }
        if (namespaceURI.equals("http://www.xmldb.org/xupdate")) {
            int id = this._consts.idForString(localName);
            if (id != 0) {
                this._xupdateInsertOperation = this._consts.isInsertOperation(id) ? true : this._xupdateInsertOperation;
                this._commands.addElement(new Integer(id));
                if (this._consts.isInstruction(id) && !this._xupdateInsertOperation) {
                    throw new SAXException("instruction <" + qName + "> is not valid for operation <" + this._lastOperation + "> !");
                }
                if (!attributes.isEmpty()) {
                    this._commands.addElement(new Integer(200));
                    this._attributes.addElement(attributes);
                }
            }
        } else if (this._xupdateInsertOperation) {
            this._commands.addElement(new Integer(101));
            Hashtable<String, String> temp = new Hashtable<String, String>();
            temp.put("name", qName);
            temp.put("namespace", namespaceURI);
            this._commands.addElement(new Integer(200));
            this._attributes.addElement(temp);
            int i2 = 0;
            while (i2 < atts.getLength()) {
                this._commands.addElement(new Integer(102));
                temp = new Hashtable();
                temp.put("name", atts.getQName(i2));
                if (atts.getURI(i2) != null) {
                    temp.put("namespace", atts.getURI(i2));
                }
                this._commands.addElement(new Integer(200));
                this._attributes.addElement(temp);
                this._commands.addElement(new Integer(300));
                this._characters.addElement(atts.getValue(i2));
                this._commands.addElement(new Integer(-102));
                ++i2;
            }
        } else {
            throw new SAXException("no insert-operation for element <" + qName + "> or wrong XUpdate-Namespace !");
        }
        this._lastOperation = qName;
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        if (namespaceURI.equals("http://www.xmldb.org/xupdate")) {
            int id = this._consts.idForString(localName);
            if (id != 0) {
                this._commands.addElement(new Integer(-id));
                this._xupdateInsertOperation = this._consts.isInsertOperation(id) ? false : this._xupdateInsertOperation;
            }
        } else if (this._xupdateInsertOperation) {
            this._commands.addElement(new Integer(-101));
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
        if (prefix != null && prefix.length() > 0) {
            this._namespaces.put(prefix, uri);
        } else {
            this._namespaces.put(null, uri);
        }
    }

    public void endPrefixMapping(String prefix) {
    }

    public void characters(char[] ch, int start, int length) {
        if (!this._commands.isEmpty()) {
            int lastInteger = (Integer)this._commands.lastElement();
            if (this._xupdateInsertOperation && lastInteger < 0) {
                this._commands.addElement(new Integer(104));
            }
            this._commands.addElement(new Integer(300));
            this._characters.addElement(new String(ch, start, length));
            if (this._xupdateInsertOperation && lastInteger < 0) {
                this._commands.addElement(new Integer(-104));
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) {
    }

    public Vector[] getCachedQuery() {
        return new Vector[]{this._commands, this._attributes, this._characters};
    }

    public HashMap getNamespaceMappings() {
        return this._namespaces;
    }
}

