/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.xupdate.lexus.commands;

import java.util.Hashtable;
import org.w3c.dom.Node;
import org.xmldb.xupdate.lexus.commands.AppendCommand;
import org.xmldb.xupdate.lexus.commands.CommandObject;
import org.xmldb.xupdate.lexus.commands.InsertAfterCommand;
import org.xmldb.xupdate.lexus.commands.InsertBeforeCommand;
import org.xmldb.xupdate.lexus.commands.RemoveCommand;
import org.xmldb.xupdate.lexus.commands.RenameCommand;
import org.xmldb.xupdate.lexus.commands.TempTree;
import org.xmldb.xupdate.lexus.commands.UpdateCommand;
import org.xmldb.xupdate.lexus.commands.VariableCommand;

public class CommandConstants {
    public static final int ROOT_ELEMENT = 0;
    public static final int COMMAND_COUNT = 7;
    public static final int COMMAND_REMOVE = 1;
    public static final int COMMAND_RENAME = 2;
    public static final int COMMAND_UPDATE = 3;
    public static final int COMMAND_VARIABLE = 4;
    public static final int COMMAND_APPEND = 5;
    public static final int COMMAND_INSERT_BEFORE = 6;
    public static final int COMMAND_INSERT_AFTER = 7;
    protected static final int FIRST_INSTRUCTION = 100;
    public static final int INSTRUCTION_ELEMENT = 101;
    public static final int INSTRUCTION_ATTRIBUTE = 102;
    public static final int INSTRUCTION_COMMENT = 103;
    public static final int INSTRUCTION_TEXT = 104;
    public static final int INSTRUCTION_CDATA = 105;
    public static final int INSTRUCTION_PROCESSING_INSTRUCTION = 106;
    public static final int INSTRUCTION_VALUE_OF = 107;
    protected static final int LAST_INSTRUCTION = 200;
    public static final int ATTRIBUTES = 200;
    public static final int CHARACTERS = 300;
    protected Hashtable _ids = null;
    protected CommandObject[] _command = null;
    public static Node _contextNode;
    public static TempTree _tempTree;

    public CommandConstants() {
        _tempTree = new TempTree();
        this.initTable();
    }

    public int idForString(String localName) {
        Integer result = (Integer)this._ids.get(localName);
        if (result == null) {
            return 0;
        }
        return result;
    }

    public CommandObject commandForID(int id) {
        switch (id) {
            case 1: {
                return this._command[0];
            }
            case 2: {
                return this._command[1];
            }
            case 3: {
                return this._command[2];
            }
            case 4: {
                return this._command[3];
            }
            case 5: {
                return this._command[4];
            }
            case 6: {
                return this._command[5];
            }
            case 7: {
                return this._command[6];
            }
        }
        return null;
    }

    public void setContextNode(Node node) throws Exception {
        if (node == null) {
            throw new IllegalArgumentException("context node must not be null !");
        }
        _contextNode = node;
        this._command = new CommandObject[7];
        this._command[0] = new RemoveCommand(_contextNode);
        this._command[1] = new RenameCommand(_contextNode);
        this._command[2] = new UpdateCommand(_contextNode);
        this._command[3] = new VariableCommand(_contextNode);
        this._command[4] = new AppendCommand(_contextNode);
        this._command[5] = new InsertBeforeCommand(_contextNode);
        this._command[6] = new InsertAfterCommand(_contextNode);
    }

    public boolean isInsertOperation(int id) {
        return id == 6 || id == 7 || id == 5;
    }

    public boolean isInstruction(int id) {
        return 100 < id && id < 200;
    }

    protected void initTable() {
        this._ids = new Hashtable();
        this._ids.put("modifications", new Integer(0));
        this._ids.put("remove", new Integer(1));
        this._ids.put("rename", new Integer(2));
        this._ids.put("update", new Integer(3));
        this._ids.put("variable", new Integer(4));
        this._ids.put("append", new Integer(5));
        this._ids.put("insert-before", new Integer(6));
        this._ids.put("insert-after", new Integer(7));
        this._ids.put("element", new Integer(101));
        this._ids.put("attribute", new Integer(102));
        this._ids.put("comment", new Integer(103));
        this._ids.put("text", new Integer(104));
        this._ids.put("cdata", new Integer(105));
        this._ids.put("value-of", new Integer(107));
        this._ids.put("processing-instruction", new Integer(106));
    }

    static {
        ROOT_ELEMENT = 0;
        COMMAND_COUNT = 7;
        COMMAND_REMOVE = 1;
        COMMAND_RENAME = 2;
        COMMAND_UPDATE = 3;
        COMMAND_VARIABLE = 4;
        COMMAND_APPEND = 5;
        COMMAND_INSERT_BEFORE = 6;
        COMMAND_INSERT_AFTER = 7;
        FIRST_INSTRUCTION = 100;
        INSTRUCTION_ELEMENT = 101;
        INSTRUCTION_ATTRIBUTE = 102;
        INSTRUCTION_COMMENT = 103;
        INSTRUCTION_TEXT = 104;
        INSTRUCTION_CDATA = 105;
        INSTRUCTION_PROCESSING_INSTRUCTION = 106;
        INSTRUCTION_VALUE_OF = 107;
        LAST_INSTRUCTION = 200;
        ATTRIBUTES = 200;
        CHARACTERS = 300;
        _contextNode = null;
        _tempTree = null;
    }
}

