/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.xupdate.lexus.commands;

import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmldb.common.xml.queries.XObject;
import org.xmldb.common.xml.queries.XPathQuery;
import org.xmldb.common.xml.queries.XPathQueryFactory;

public abstract class CommandObject {
    protected static XPathQuery _xpath = null;
    protected Document _document = null;
    protected Node _contextNode = null;
    protected NodeList _selection = null;
    protected Hashtable _attributes = null;
    protected Vector _characters = null;

    public CommandObject(Node contextNode) throws Exception {
        if (contextNode == null) {
            throw new IllegalArgumentException("Argument contextNode must not be null.");
        }
        if (_xpath == null) {
            _xpath = XPathQueryFactory.newInstance().newXPathQuery();
        }
        this._contextNode = contextNode;
        switch (contextNode.getNodeType()) {
            case 9: {
                this._document = (Document)contextNode;
                break;
            }
            default: {
                this._document = contextNode.getOwnerDocument();
            }
        }
        this._characters = new Vector();
    }

    public void reset() {
        this._characters.clear();
    }

    public synchronized void selectNodes(String qString) throws Exception {
        if (qString == null) {
            throw new IllegalArgumentException("Argument qString must not be null.");
        }
        _xpath.setQString(qString);
        XObject result = _xpath.execute(this._contextNode);
        if (result.getType() != 4) {
            throw new Exception("XPath leads not to a Node or NodeList !");
        }
        this._selection = result.nodeset();
        if (this._selection.getLength() == 0) {
            throw new Exception("no nodes selected !");
        }
    }

    public void submitAttributes(Hashtable attributes) {
        this._attributes = attributes;
    }

    public void submitCharacters(String data) {
        this._characters.addElement(data);
    }

    public abstract boolean submitInstruction(int var1) throws Exception;

    public abstract boolean executeInstruction() throws Exception;

    public abstract Node execute() throws Exception;

    public static XPathQuery getXPath() {
        return _xpath;
    }
}

