/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.xupdate.lexus.commands;

import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xmldb.xupdate.lexus.commands.CommandObject;
import org.xmldb.xupdate.lexus.commands.InsertAttribute;
import org.xmldb.xupdate.lexus.commands.InsertCDATA;
import org.xmldb.xupdate.lexus.commands.InsertComment;
import org.xmldb.xupdate.lexus.commands.InsertElement;
import org.xmldb.xupdate.lexus.commands.InsertProcessingInstruction;
import org.xmldb.xupdate.lexus.commands.InsertStates;
import org.xmldb.xupdate.lexus.commands.InsertText;
import org.xmldb.xupdate.lexus.commands.InsertVariable;

public abstract class InsertCommand
extends CommandObject {
    protected Node _current = null;
    protected Node _result = null;
    protected int _state = -1;
    protected static InsertStates[] _states = null;
    public static final int STATE_COUNT = 7;

    public InsertCommand(Node contextNode) throws Exception {
        super(contextNode);
    }

    public void submitAttributes(Hashtable attributes) {
        if (this._state < 0) {
            super.submitAttributes(attributes);
        } else {
            _states[this._state].submitAttributes(attributes);
        }
    }

    public void submitCharacters(String data) {
        if (this._state < 0) {
            super.submitCharacters(data);
        } else {
            _states[this._state].submitCharacters(data);
        }
    }

    public boolean submitInstruction(int instruction) throws Exception {
        if (this._result == null) {
            this._current = this._result = this._document.createElementNS(null, "temporaryXUpdateTree");
            this._document.getDocumentElement().appendChild(this._result);
        }
        if (this._state >= 0) {
            this._current = _states[this._state].execute(this._current);
        }
        switch (instruction) {
            case 101: {
                this._state = 0;
                break;
            }
            case 102: {
                this._state = 1;
                break;
            }
            case 103: {
                this._state = 2;
                break;
            }
            case 104: {
                this._state = 3;
                break;
            }
            case 105: {
                this._state = 4;
                break;
            }
            case 106: {
                this._state = 5;
                break;
            }
            case 107: {
                this._state = 6;
                break;
            }
            default: {
                this._state = -1;
            }
        }
        if (this._state >= 0) {
            _states[this._state].reset();
        }
        return this._state >= 0;
    }

    public boolean executeInstruction() throws Exception {
        if (this._state >= 0) {
            this._current = _states[this._state].execute(this._current);
            this._state = -1;
        }
        if (!this._current.equals(this._result)) {
            switch (this._current.getNodeType()) {
                case 2: {
                    this._current = ((Attr)this._current).getOwnerElement();
                    return true;
                }
            }
            this._current = this._current.getParentNode();
            return true;
        }
        return false;
    }

    protected void insertAttributes(NamedNodeMap attributes, Node node) throws Exception {
        if (attributes == null) {
            return;
        }
        if (node.getNodeType() != 1) {
            throw new Exception("can't append attribute to !");
        }
        int attributesLength = attributes.getLength();
        int j = 0;
        while (j < attributesLength) {
            Attr attribute = (Attr)attributes.item(j);
            String namespaceURI = attribute.getNamespaceURI();
            ((Element)node).setAttributeNS(namespaceURI, attribute.getNodeName(), attribute.getNodeValue());
            ++j;
        }
    }

    public abstract Node execute() throws Exception;

    static {
        STATE_COUNT = 7;
        _states = new InsertStates[7];
        InsertCommand._states[0] = new InsertElement();
        InsertCommand._states[1] = new InsertAttribute();
        InsertCommand._states[2] = new InsertComment();
        InsertCommand._states[3] = new InsertText();
        InsertCommand._states[4] = new InsertCDATA();
        InsertCommand._states[5] = new InsertProcessingInstruction();
        InsertCommand._states[6] = new InsertVariable();
    }
}

