/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.xupdate.unittests;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompareDocuments {
    public void compare(Node node1, Node node2) throws Exception {
        this.compare(node1, node2, "", true);
    }

    public void compare(Node node1, Node node2, String space, boolean show) throws Exception {
        if (node1.getNodeType() == 9 && node2.getNodeType() == 9) {
            this.compare(((Document)node1).getDocumentElement(), ((Document)node2).getDocumentElement(), space, show);
            return;
        }
        if (show) {
            System.err.print(space);
            switch (node1.getNodeType()) {
                case 2: {
                    System.err.print("@");
                }
            }
            System.err.print(node1 + "[" + node1.getNodeType() + "] <==> ");
            switch (node2.getNodeType()) {
                case 2: {
                    System.err.print("@");
                }
            }
            System.err.println(node2 + "[" + node2.getNodeType() + "]");
        }
        if (node1.getNodeType() != node2.getNodeType()) {
            throw new Exception("different node types (" + node1.getNodeType() + "!=" + node2.getNodeType() + ")...");
        }
        if (node1.getNamespaceURI() == null ^ node2.getNamespaceURI() == null) {
            throw new Exception("only one node has a Namespace");
        }
        if (node1.getNamespaceURI() != null && node2.getNamespaceURI() != null && !node1.getNamespaceURI().equals(node2.getNamespaceURI())) {
            throw new Exception("different NamespaceURI's (" + node1.getNamespaceURI() + "!=" + node2.getNamespaceURI() + ")...");
        }
        if (!node1.getNodeName().equals(node2.getNodeName())) {
            throw new Exception("different node names (" + node1.getNodeName() + "!=" + node2.getNodeName() + "...");
        }
        if (node1.getNodeValue() != null && node2.getNodeValue() != null && !node1.getNodeValue().equals(node2.getNodeValue())) {
            throw new Exception("different node values (" + node1.getNodeValue() + "!=" + node2.getNodeValue() + ")...");
        }
        NamedNodeMap attr1 = node1.getAttributes();
        NamedNodeMap attr2 = node2.getAttributes();
        if (attr1 != null && attr2 != null) {
            if (attr1.getLength() != attr2.getLength()) {
                throw new Exception("different attribute counts...");
            }
            int i = 0;
            while (i < attr1.getLength()) {
                this.compare(attr1.item(i), attr2.item(i), space, show);
                ++i;
            }
        }
        NodeList list1 = node1.getChildNodes();
        NodeList list2 = node2.getChildNodes();
        if (list1.getLength() != list2.getLength()) {
            throw new Exception("different child node counts(" + list1.getLength() + "!=" + list2.getLength() + ")...");
        }
        Node child1 = node1.getFirstChild();
        Node child2 = node2.getFirstChild();
        space = space + "    ";
        while (child1 != null) {
            this.compare(child1, child2, space, show);
            child1 = child1.getNextSibling();
            child2 = child2.getNextSibling();
        }
    }
}

