/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.xupdate.unittests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.xmldb.xupdate.lexus.XUpdateQueryImpl;
import org.xmldb.xupdate.unittests.XhiveNodeMatcher;

public class LexusTestCase
extends TestCase {
    protected static String RESOURCE_LOCATION = "org/xmldb/xupdate/unittests/";
    protected static String XPATHQUERYFACTORY = "org.xmldb.common.xml.queries.xalan2.XPathQueryFactoryImpl";
    protected static final String INPUT_ADDRESS_DOCUMENT = "input/address.xml";
    protected static final String INPUT_ADDRESS_NS_DOCUMENT = "input/address-ns.xml";
    static final String UPDATE_REMOVE_DOCUMENT = "updates/updates.remove.xml";
    static final String UPDATE_REMOVE_ATTRIBUTE_DOCUMENT = "updates/updates.remove.attribute.xml";
    static final String UPDATE_REMOVE_TEXT_DOCUMENT = "updates/updates.remove.text.xml";
    static final String UPDATE_INSERTBEFORE_ELEMENT_DOCUMENT = "updates/updates.insertbefore.xml";
    static final String UPDATE_INSERTAFTER_ELEMENT_DOCUMENT = "updates/updates.insertafter.xml";
    static final String UPDATE_INSERTAFTER_ELEMENT_NS_DOCUMENT = "updates/updates.insertafter.ns.xml";
    static final String UPDATE_INSERTAFTER_TEXT_DOCUMENT = "updates/updates.insertafter.text.xml";
    static final String UPDATE_INSERTAFTER_ATTRIBUTE_DOCUMENT = "updates/updates.insertafter.attribute.xml";
    static final String UPDATE_INSERTBEFORE_ATTRIBUTE_DOCUMENT = "updates/updates.insertbefore.attribute.xml";
    static final String UPDATE_RENAME_ELEMENT_DOCUMENT = "updates/updates.rename.xml";
    static final String UPDATE_RENAME_ATTRIBUTE_DOCUMENT = "updates/updates.rename.attribute.xml";
    static final String UPDATE_UPDATE_ELEMENT_DOCUMENT = "updates/updates.update.xml";
    static final String UPDATE_UPDATE_ATTRIBUTE_DOCUMENT = "updates/updates.update.attribute.xml";
    static final String UPDATE_APPEND_ATTRIBUTE_DOCUMENT = "updates/updates.append.attribute.xml";
    static final String UPDATE_APPEND_CDATA_DOCUMENT = "updates/updates.append.cdata.xml";
    static final String UPDATE_VARIABLE_DOCUMENT = "updates/updates.variable.xml";
    static final String UPDATE_INPUT_NS_INSERTAFTER_ELEMENT_DOCUMENT = "updates/updates.inputns.insertafter.xml";
    static final String BUG_UPDATES_INSERTAFTER_ATTRIBUTE_DOCUMENT = "bugs/updates/bugs.updates.insertafter.attribute.xml";
    static final String BUG_UPDATES_UPDATE_ENTITIES_DOCUMENT = "bugs/updates/bugs.updates.update.entities.xml";
    static final String RESULT_REMOVE_DOCUMENT = "results/results.remove.xml";
    static final String RESULT_REMOVE_ATTRIBUTE_DOCUMENT = "results/results.remove.attribute.xml";
    static final String RESULT_REMOVE_TEXT_DOCUMENT = "results/results.remove.text.xml";
    static final String RESULT_INSERTBEFORE_ELEMENT_DOCUMENT = "results/results.insertbefore.xml";
    static final String RESULT_INSERTAFTER_ELEMENT_DOCUMENT = "results/results.insertafter.xml";
    static final String RESULT_INSERTAFTER_ELEMENT_NS_DOCUMENT = "results/results.insertafter.ns.xml";
    static final String RESULT_INSERTAFTER_TEXT_DOCUMENT = "results/results.insertafter.text.xml";
    static final String RESULT_INSERTAFTER_ATTRIBUTE_DOCUMENT = "results/results.insertafter.attribute.xml";
    static final String RESULT_INSERTBEFORE_ATTRIBUTE_DOCUMENT = "results/results.insertbefore.attribute.xml";
    static final String RESULT_RENAME_ELEMENT_DOCUMENT = "results/results.rename.xml";
    static final String RESULT_RENAME_ATTRIBUTE_DOCUMENT = "results/results.rename.attribute.xml";
    static final String RESULT_UPDATE_ELEMENT_DOCUMENT = "results/results.update.xml";
    static final String RESULT_UPDATE_ATTRIBUTE_DOCUMENT = "results/results.update.attribute.xml";
    static final String RESULT_APPEND_ATTRIBUTE_DOCUMENT = "results/results.append.attribute.xml";
    static final String RESULT_APPEND_CDATA_DOCUMENT = "results/results.append.cdata.xml";
    static final String RESULT_VARIABLE_DOCUMENT = "results/results.variable.xml";
    static final String RESULT_INPUT_NS_INSERTAFTER_ELEMENT_DOCUMENT = "results/results.inputns.insertafter.xml";
    static final String BUG_RESULT_INSERTAFTER_ATTRIBUTE_DOCUMENT = "bugs/results/bugs.results.insertafter.attribute.xml";
    static final String BUG_RESULT_UPDATE_ENTITIES_DOCUMENT = "bugs/results/bugs.results.update.entities.xml";

    public LexusTestCase(String name) {
        super(name);
    }

    public void mainTest(String queryFile, String inputFile, String resultFile) throws Exception {
        Document result = this.update(queryFile, inputFile);
        this.removeWhiteSpace(result);
        Document expected = this.parseInputFile(RESOURCE_LOCATION + resultFile);
        this.removeWhiteSpace(expected);
        new XhiveNodeMatcher();
        XhiveNodeMatcher.compareNodes(expected, result, true, true);
    }

    public void mainTest(String queryFile, String resultFile) throws Exception {
        this.mainTest(queryFile, INPUT_ADDRESS_DOCUMENT, resultFile);
    }

    protected Document update(String queryFile, String inputFile) throws Exception {
        String query = this.readUpdateFile(RESOURCE_LOCATION + queryFile);
        Document document = this.parseInputFile(RESOURCE_LOCATION + inputFile);
        XUpdateQueryImpl xupdate = new XUpdateQueryImpl();
        xupdate.setQString(query);
        System.setProperty("org.xmldb.common.xml.queries.XPathQueryFactory", XPATHQUERYFACTORY);
        xupdate.execute(document);
        return document;
    }

    protected String readUpdateFile(String updateFileName) throws Exception {
        File updateFile = new File(updateFileName);
        if (!updateFile.exists()) {
            throw new IllegalArgumentException("update file does not exist, or cannot be found (" + updateFile.toString() + ")");
        }
        BufferedReader br = new BufferedReader(new FileReader(updateFile));
        char[] characters = new char[new Long(updateFile.length()).intValue()];
        br.read(characters, 0, new Long(updateFile.length()).intValue());
        br.close();
        return new String(characters);
    }

    protected Document parseInputFile(String inputFile) throws Exception {
        DocumentBuilderFactory parserFactory = DocumentBuilderFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        DocumentBuilder builder = parserFactory.newDocumentBuilder();
        return builder.parse(inputFile);
    }

    private void removeWhiteSpace(Document document) {
        NodeIterator nodeIterator = ((DocumentTraversal)((Object)document)).createNodeIterator(document, 4, null, true);
        Node node = nodeIterator.nextNode();
        while (node != null) {
            if (node.getNodeValue().trim().compareTo("") == 0) {
                node.getParentNode().removeChild(node);
            }
            node = nodeIterator.nextNode();
        }
    }

    static {
        INPUT_ADDRESS_DOCUMENT = INPUT_ADDRESS_DOCUMENT;
        INPUT_ADDRESS_NS_DOCUMENT = INPUT_ADDRESS_NS_DOCUMENT;
        UPDATE_REMOVE_DOCUMENT = UPDATE_REMOVE_DOCUMENT;
        UPDATE_REMOVE_ATTRIBUTE_DOCUMENT = UPDATE_REMOVE_ATTRIBUTE_DOCUMENT;
        UPDATE_REMOVE_TEXT_DOCUMENT = UPDATE_REMOVE_TEXT_DOCUMENT;
        UPDATE_INSERTBEFORE_ELEMENT_DOCUMENT = UPDATE_INSERTBEFORE_ELEMENT_DOCUMENT;
        UPDATE_INSERTAFTER_ELEMENT_DOCUMENT = UPDATE_INSERTAFTER_ELEMENT_DOCUMENT;
        UPDATE_INSERTAFTER_ELEMENT_NS_DOCUMENT = UPDATE_INSERTAFTER_ELEMENT_NS_DOCUMENT;
        UPDATE_INSERTAFTER_TEXT_DOCUMENT = UPDATE_INSERTAFTER_TEXT_DOCUMENT;
        UPDATE_INSERTAFTER_ATTRIBUTE_DOCUMENT = UPDATE_INSERTAFTER_ATTRIBUTE_DOCUMENT;
        UPDATE_INSERTBEFORE_ATTRIBUTE_DOCUMENT = UPDATE_INSERTBEFORE_ATTRIBUTE_DOCUMENT;
        UPDATE_RENAME_ELEMENT_DOCUMENT = UPDATE_RENAME_ELEMENT_DOCUMENT;
        UPDATE_RENAME_ATTRIBUTE_DOCUMENT = UPDATE_RENAME_ATTRIBUTE_DOCUMENT;
        UPDATE_UPDATE_ELEMENT_DOCUMENT = UPDATE_UPDATE_ELEMENT_DOCUMENT;
        UPDATE_UPDATE_ATTRIBUTE_DOCUMENT = UPDATE_UPDATE_ATTRIBUTE_DOCUMENT;
        UPDATE_APPEND_ATTRIBUTE_DOCUMENT = UPDATE_APPEND_ATTRIBUTE_DOCUMENT;
        UPDATE_APPEND_CDATA_DOCUMENT = UPDATE_APPEND_CDATA_DOCUMENT;
        UPDATE_VARIABLE_DOCUMENT = UPDATE_VARIABLE_DOCUMENT;
        UPDATE_INPUT_NS_INSERTAFTER_ELEMENT_DOCUMENT = UPDATE_INPUT_NS_INSERTAFTER_ELEMENT_DOCUMENT;
        BUG_UPDATES_INSERTAFTER_ATTRIBUTE_DOCUMENT = BUG_UPDATES_INSERTAFTER_ATTRIBUTE_DOCUMENT;
        BUG_UPDATES_UPDATE_ENTITIES_DOCUMENT = BUG_UPDATES_UPDATE_ENTITIES_DOCUMENT;
        RESULT_REMOVE_DOCUMENT = RESULT_REMOVE_DOCUMENT;
        RESULT_REMOVE_ATTRIBUTE_DOCUMENT = RESULT_REMOVE_ATTRIBUTE_DOCUMENT;
        RESULT_REMOVE_TEXT_DOCUMENT = RESULT_REMOVE_TEXT_DOCUMENT;
        RESULT_INSERTBEFORE_ELEMENT_DOCUMENT = RESULT_INSERTBEFORE_ELEMENT_DOCUMENT;
        RESULT_INSERTAFTER_ELEMENT_DOCUMENT = RESULT_INSERTAFTER_ELEMENT_DOCUMENT;
        RESULT_INSERTAFTER_ELEMENT_NS_DOCUMENT = RESULT_INSERTAFTER_ELEMENT_NS_DOCUMENT;
        RESULT_INSERTAFTER_TEXT_DOCUMENT = RESULT_INSERTAFTER_TEXT_DOCUMENT;
        RESULT_INSERTAFTER_ATTRIBUTE_DOCUMENT = RESULT_INSERTAFTER_ATTRIBUTE_DOCUMENT;
        RESULT_INSERTBEFORE_ATTRIBUTE_DOCUMENT = RESULT_INSERTBEFORE_ATTRIBUTE_DOCUMENT;
        RESULT_RENAME_ELEMENT_DOCUMENT = RESULT_RENAME_ELEMENT_DOCUMENT;
        RESULT_RENAME_ATTRIBUTE_DOCUMENT = RESULT_RENAME_ATTRIBUTE_DOCUMENT;
        RESULT_UPDATE_ELEMENT_DOCUMENT = RESULT_UPDATE_ELEMENT_DOCUMENT;
        RESULT_UPDATE_ATTRIBUTE_DOCUMENT = RESULT_UPDATE_ATTRIBUTE_DOCUMENT;
        RESULT_APPEND_ATTRIBUTE_DOCUMENT = RESULT_APPEND_ATTRIBUTE_DOCUMENT;
        RESULT_APPEND_CDATA_DOCUMENT = RESULT_APPEND_CDATA_DOCUMENT;
        RESULT_VARIABLE_DOCUMENT = RESULT_VARIABLE_DOCUMENT;
        RESULT_INPUT_NS_INSERTAFTER_ELEMENT_DOCUMENT = RESULT_INPUT_NS_INSERTAFTER_ELEMENT_DOCUMENT;
        BUG_RESULT_INSERTAFTER_ATTRIBUTE_DOCUMENT = BUG_RESULT_INSERTAFTER_ATTRIBUTE_DOCUMENT;
        BUG_RESULT_UPDATE_ENTITIES_DOCUMENT = BUG_RESULT_UPDATE_ENTITIES_DOCUMENT;
    }
}

