/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.xupdate.unittests;

import junit.framework.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;

public class XhiveNodeMatcher {
    protected static String nodeTypeToString(int type) {
        switch (type) {
            case 1: {
                return "ELEMENT_NODE";
            }
            case 2: {
                return "ATTRIBUTE_NODE";
            }
            case 3: {
                return "TEXT_NODE";
            }
            case 4: {
                return "CDATA_SECTION_NODE";
            }
            case 5: {
                return "ENTITY_REFERENCE_NODE";
            }
            case 6: {
                return "ENTITY_NODE";
            }
            case 7: {
                return "PROCESSING_INSTRUCTION_NODE";
            }
            case 8: {
                return "COMMENT_NODE";
            }
            case 9: {
                return "DOCUMENT_NODE";
            }
            case 10: {
                return "DOCUMENT_TYPE_NODE";
            }
            case 11: {
                return "DOCUMENT_FRAGMENT_NODE";
            }
            case 12: {
                return "NOTATION_NODE";
            }
        }
        return "UNKNOWN NODE TYPE";
    }

    public static void compareNodes(Node origin, Node target, boolean clone, boolean deep) {
        if (origin != null || target != null) {
            if (origin != null) {
                Assert.assertNotNull((String)("NodeMatcher : Missing node, origin tagname : " + origin.getNodeName()), (Object)target);
            } else {
                Assert.assertNull((String)("NodeMatcher : extra node: " + (target != null ? target.getNodeName() : "")), (Object)target);
            }
            Assert.assertEquals((String)"NodeMatcher : node types do not match", (String)XhiveNodeMatcher.nodeTypeToString(origin.getNodeType()), (String)XhiveNodeMatcher.nodeTypeToString(target.getNodeType()));
            Assert.assertEquals((String)"NodeMatcher : node names do not match.", (String)origin.getNodeName(), (String)target.getNodeName());
            Assert.assertEquals((String)"NodeMatcher : node values do not match.", (String)origin.getNodeValue(), (String)target.getNodeValue());
            Assert.assertEquals((String)"NodeMatcher : local names do not match.", (String)origin.getLocalName(), (String)target.getLocalName());
            Assert.assertEquals((String)("NodeMatcher : namespace URI's do not match (localName=" + origin.getLocalName() + ")."), (String)origin.getNamespaceURI(), (String)target.getNamespaceURI());
            Assert.assertEquals((String)"NodeMatcher : prefixes do not match.", (String)origin.getPrefix(), (String)target.getPrefix());
            if (origin.hasAttributes()) {
                Assert.assertTrue((String)("NodeMatcher : hasAttributes() should return true for node with name " + origin.getNodeName()), (boolean)target.hasAttributes());
            }
            if ((clone || origin.getNodeType() != 5) && origin.hasChildNodes() && deep) {
                Assert.assertTrue((String)("NodeMatcher : hasChildren() should return true for node with name " + origin.getNodeName()), (boolean)target.hasChildNodes());
            }
            if (origin.getNodeType() == 1) {
                XhiveNodeMatcher.compareNamedNodeMaps(origin.getAttributes(), target.getAttributes(), clone, deep);
            }
            if (origin.getNodeType() == 2) {
                XhiveNodeMatcher.compareAttrs((Attr)origin, (Attr)target, clone, deep);
            }
            if (origin.getNodeType() == 6) {
                XhiveNodeMatcher.compareEntities((Entity)origin, (Entity)target);
            }
            if (origin.getNodeType() == 7) {
                XhiveNodeMatcher.comparePIs((ProcessingInstruction)origin, (ProcessingInstruction)target);
            }
            if (origin.getNodeType() == 12) {
                XhiveNodeMatcher.compareNotations((Notation)origin, (Notation)target);
            }
            if (origin.getNodeType() == 9) {
                XhiveNodeMatcher.compareDocuments((Document)origin, (Document)target, clone, deep);
            }
            if (deep && (clone || origin.getNodeType() != 5)) {
                Node originPointer = origin.getFirstChild();
                Node targetPointer = target.getFirstChild();
                while (originPointer != null) {
                    Assert.assertNotNull((String)("NodeMatcher : Child list for node does not match, missing node " + originPointer.getNodeName()), (Object)targetPointer);
                    XhiveNodeMatcher.compareNodes(originPointer, targetPointer, clone, deep);
                    originPointer = originPointer.getNextSibling();
                    targetPointer = targetPointer.getNextSibling();
                }
                if (targetPointer != null && originPointer == null) {
                    Assert.fail((String)("NodeMatcher : Child list does not match, node should not be there :" + targetPointer.getNodeName() + ", " + targetPointer.getNodeValue()));
                }
            }
        }
    }

    public static void compareNodeLists(NodeList origin, NodeList target, boolean clone, boolean deep) {
        if (origin != null) {
            Assert.assertNotNull((String)"NodeMatcher : expected nodelist not found", (Object)target);
            Assert.assertEquals((String)"NodeMatcher : nodelist item count does not match.", (int)origin.getLength(), (int)target.getLength());
            int i = 0;
            while (i < origin.getLength()) {
                Node originNode = origin.item(i);
                Node targetNode = target.item(i);
                XhiveNodeMatcher.compareNodes(originNode, targetNode, clone, deep);
                ++i;
            }
        } else {
            Assert.assertNull((String)"NodeMatcher : unexpected nodelist found", (Object)target);
        }
    }

    public static void compareNamedNodeMaps(NamedNodeMap origin, NamedNodeMap target, boolean clone, boolean deep) {
        if (origin != null) {
            Assert.assertNotNull((String)"NodeMatcher : expected namednodemap not found", (Object)target);
            Assert.assertEquals((String)"NodeMatcher : nodemap item count does not match.", (int)origin.getLength(), (int)target.getLength());
            int i = 0;
            while (i < origin.getLength()) {
                Node originNode = origin.item(i);
                Node targetNode = XhiveNodeMatcher.lookupTargetNode(target, originNode);
                XhiveNodeMatcher.compareNodes(originNode, targetNode, clone, deep);
                ++i;
            }
        } else {
            Assert.assertNull((String)"NodeMatcher : unexpected namednodemap found", (Object)target);
        }
    }

    private static Node lookupTargetNode(NamedNodeMap target, Node originNode) {
        if (originNode.getLocalName() == null) {
            return target.getNamedItem(originNode.getNodeName());
        }
        return target.getNamedItemNS(originNode.getNamespaceURI(), originNode.getLocalName());
    }

    protected static void compareAttrs(Attr origin, Attr target, boolean clone, boolean deep) {
        if (clone && origin.getSpecified()) {
            Assert.assertTrue((String)"NodeMatcher : attribute specified does not match", (boolean)target.getSpecified());
        }
    }

    protected static void compareEntities(Entity origin, Entity target) {
        Assert.assertEquals((String)"NodeMatcher : entity public id's do not match.", (String)origin.getPublicId(), (String)target.getPublicId());
        Assert.assertEquals((String)"NodeMatcher : entity system id's do not match.", (String)origin.getSystemId(), (String)target.getSystemId());
        Assert.assertEquals((String)"NodeMatcher : entity notation names do not match.", (String)origin.getNotationName(), (String)target.getNotationName());
    }

    protected static void comparePIs(ProcessingInstruction origin, ProcessingInstruction target) {
        Assert.assertEquals((String)"NodeMatcher : processing instruction targets do not match.", (String)origin.getTarget(), (String)target.getTarget());
        Assert.assertEquals((String)"NodeMatcher : processing instruction data does not match.", (String)origin.getData(), (String)target.getData());
    }

    protected static void compareNotations(Notation origin, Notation target) {
        Assert.assertEquals((String)"NodeMatcher : notation public id's do not match.", (String)origin.getPublicId(), (String)target.getPublicId());
        Assert.assertEquals((String)"NodeMatcher : notation system id's do not match.", (String)origin.getSystemId(), (String)target.getSystemId());
    }

    public static void compareDocTypes(DocumentType origin, DocumentType target, boolean clone, boolean deep) {
        if (origin == null) {
            Assert.assertNull((String)"NodeMatcher: One doctype is null and one is not", (Object)target);
        } else {
            Assert.assertNotNull((String)"NodeMatcher: One doctype is null and one is not", (Object)target);
        }
        Assert.assertEquals((String)"NodeMatcher : document type public id's do not match.", (String)origin.getPublicId(), (String)target.getPublicId());
        Assert.assertEquals((String)"NodeMatcher : document type system id's do not match.", (String)origin.getSystemId(), (String)target.getSystemId());
        Assert.assertEquals((String)"NodeMatcher : document type names do not match.", (String)origin.getName(), (String)target.getName());
        XhiveNodeMatcher.compareNamedNodeMaps(origin.getEntities(), target.getEntities(), clone, deep);
        XhiveNodeMatcher.compareNamedNodeMaps(origin.getNotations(), target.getNotations(), clone, deep);
    }

    protected static void compareDocuments(Document origin, Document target, boolean clone, boolean deep) {
        DocumentType originDocumentType = origin.getDoctype();
        DocumentType targetDocumentType = target.getDoctype();
        XhiveNodeMatcher.compareNodes(originDocumentType, targetDocumentType, clone, deep);
    }
}

