/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XmlCompare {
    protected static final String FEATURE_XML_ROUNDTRIP = "http://xmlpull.org/v1/doc/features.html#xml-roundtrip";

    public static void main(String[] args) throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        XmlPullParser pp = factory.newPullParser();
        try {
            pp.setFeature(FEATURE_XML_ROUNDTRIP, false);
        }
        catch (XmlPullParserException ex) {
            throw new RuntimeException("could nto disable roundtrip feature: " + (Object)((Object)ex));
        }
        System.out.println("parser implementation class is " + pp.getClass());
        String FILE = "fcked_up2.xml";
        pp.setInput((Reader)new FileReader("fcked_up2.xml"));
        String text = XmlCompare.getNextElementText(pp);
        XmlCompare.compareXmlTwoFiles(new FileReader("fcked_up2.xml"), new StringReader(text));
    }

    public static String getNextElementText(XmlPullParser parser) throws XmlPullParserException, IOException {
        if (!parser.getFeature(FEATURE_XML_ROUNDTRIP)) {
            throw new RuntimeException("roundtrip feature must be enabled to get tag content");
        }
        int level = 1;
        StringBuffer buf = new StringBuffer();
        parser.nextTag();
        buf.append(parser.getText());
        while (level > 0) {
            int event = parser.next();
            String text = parser.getText();
            if (event == 2) {
                buf.append(text);
                if (parser.isEmptyElementTag()) {
                    parser.next();
                    continue;
                }
                ++level;
                continue;
            }
            if (event == 3) {
                buf.append(text);
                --level;
                continue;
            }
            if (text.length() <= 0) continue;
            StringBuffer escapedText = new StringBuffer(text.length());
            int i = 0;
            while (i < text.length()) {
                char ch = text.charAt(i);
                if (ch == '<') {
                    escapedText.append("&lt;");
                } else if (ch == '&') {
                    escapedText.append("&amp;");
                } else if (ch == '\"') {
                    escapedText.append("&quot;");
                } else if (ch == '\'') {
                    escapedText.append("&apos;");
                } else {
                    escapedText.append(ch);
                }
                ++i;
            }
            buf.append(escapedText);
        }
        return buf.toString();
    }

    static void compareXmlTwoFiles(Reader rr, Reader rq) throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)"org.xmlpull.mxp1.MXParserFactory", null);
        factory.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        XmlPullParser r = factory.newPullParser();
        r.setInput(rr);
        XmlPullParser q = factory.newPullParser();
        q.setInput(rq);
        while (true) {
            r.next();
            q.next();
            if (r.getEventType() != q.getEventType()) {
                throw new RuntimeException("inconsistent events");
            }
            if (r.getEventType() == 1) break;
            if (r.getEventType() == 2 || r.getEventType() == 3) {
                String qName;
                String rName = r.getName();
                if (!rName.equals(qName = q.getName())) {
                    throw new RuntimeException("element names mismatch");
                }
                r.getEventType();
            } else if (r.getEventType() == 4) {
                String qText;
                String rText = r.getText();
                if (!rText.equals(qText = q.getText())) {
                    throw new RuntimeException("text content mismatch '" + rText + "' and '" + qText + "'");
                }
            } else {
                throw new RuntimeException("unknown event type " + r.getEventType() + r.getPositionDescription());
            }
            System.err.print(".");
        }
        System.err.println("\nOK");
    }
}

