/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcHttpClientConfig;
import org.apache.xmlrpc.client.XmlRpcStreamTransport;
import org.apache.xmlrpc.util.HttpUtil;

public abstract class XmlRpcHttpTransport
extends XmlRpcStreamTransport {
    private String userAgent;
    public static final String USER_AGENT = "Apache XML RPC 3.0";

    protected XmlRpcHttpTransport(XmlRpcClient pClient, String pUserAgent) {
        super(pClient);
        this.userAgent = pUserAgent;
    }

    protected String getUserAgent() {
        return this.userAgent;
    }

    protected abstract void setRequestHeader(String var1, String var2);

    protected void setCredentials(XmlRpcHttpClientConfig pConfig) throws XmlRpcClientException {
        String auth;
        try {
            auth = HttpUtil.encodeBasicAuthentication((String)pConfig.getBasicUserName(), (String)pConfig.getBasicPassword(), (String)pConfig.getBasicEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new XmlRpcClientException("Unsupported encoding: " + pConfig.getBasicEncoding(), e);
        }
        if (auth != null) {
            this.setRequestHeader("Authorization", "Basic " + auth);
        }
    }

    protected void setContentLength(int pLength) {
        this.setRequestHeader("Content-Length", Integer.toString(pLength));
    }

    protected void setCompressionHeaders(XmlRpcHttpClientConfig pConfig) {
        if (pConfig.isGzipCompressing()) {
            this.setRequestHeader("Content-Encoding", "gzip");
        }
        if (pConfig.isGzipRequesting()) {
            this.setRequestHeader("Accept-Encoding", "gzip");
        }
    }

    protected void initHttpHeaders(XmlRpcRequest pRequest) throws XmlRpcClientException {
        XmlRpcHttpClientConfig config = (XmlRpcHttpClientConfig)pRequest.getConfig();
        this.setRequestHeader("Content-Type", "text/xml");
        this.setRequestHeader("User-Agent", this.getUserAgent());
        this.setCredentials(config);
        this.setCompressionHeaders(config);
    }

    public Object sendRequest(XmlRpcRequest pRequest) throws XmlRpcException {
        this.initHttpHeaders(pRequest);
        return super.sendRequest(pRequest);
    }

    protected boolean isUsingByteArrayOutput(XmlRpcHttpClientConfig pConfig) throws XmlRpcException {
        return !pConfig.isEnabledForExtensions() || !pConfig.isContentLengthOptional();
    }

    protected XmlRpcStreamTransport.RequestWriter newRequestWriter(XmlRpcRequest pRequest) throws XmlRpcException {
        XmlRpcHttpClientConfig config = (XmlRpcHttpClientConfig)pRequest.getConfig();
        if (this.isUsingByteArrayOutput(config)) {
            ByteArrayRequestWriter result = new ByteArrayRequestWriter(pRequest);
            this.setContentLength(result.getContentLength());
            return result;
        }
        return super.newRequestWriter(pRequest);
    }

    protected class ByteArrayRequestWriter
    extends XmlRpcStreamTransport.RequestWriter {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        protected ByteArrayRequestWriter(XmlRpcRequest pRequest) throws XmlRpcException {
            super(pRequest);
            super.writeUncompressed(this.baos);
        }

        protected void writeUncompressed(OutputStream pStream) throws XmlRpcException {
            try {
                this.baos.writeTo(pStream);
                pStream.close();
                pStream = null;
            }
            catch (IOException e) {
                throw new XmlRpcException("Failed to write request: " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (pStream != null) {
                    try {
                        pStream.close();
                    }
                    catch (Throwable ignore) {}
                }
            }
        }

        protected int getContentLength() {
            return this.baos.size();
        }
    }
}

