/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcStreamTransport;
import org.apache.xmlrpc.common.LocalStreamConnection;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.common.XmlRpcStreamRequestProcessor;

public class XmlRpcLocalStreamTransport
extends XmlRpcStreamTransport {
    private final XmlRpcStreamRequestProcessor localServer;
    private LocalStreamConnection conn;

    public XmlRpcLocalStreamTransport(XmlRpcClient pClient, XmlRpcStreamRequestProcessor pServer) {
        super(pClient);
        this.localServer = pServer;
    }

    protected boolean isResponseGzipCompressed(XmlRpcStreamRequestConfig pConfig) {
        return pConfig.isGzipRequesting();
    }

    protected void close() throws XmlRpcClientException {
    }

    protected InputStream getInputStream() throws XmlRpcException {
        this.localServer.execute(this.conn.getConfig(), this.conn.getServerStreamConnection());
        return new ByteArrayInputStream(this.conn.getResponse().toByteArray());
    }

    protected void writeRequest(XmlRpcStreamTransport.RequestWriter pWriter) throws XmlRpcException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        pWriter.write(baos);
        XmlRpcStreamRequestConfig config = (XmlRpcStreamRequestConfig)pWriter.getRequest().getConfig();
        this.conn = new LocalStreamConnection(config, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
    }
}

