/*
 * Decompiled with CFR 0.152.
 */
package helma.xmlrpc;

public class Base64 {
    private static char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
    private static byte[] codes = new byte[256];

    public static char[] encode(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index + 0] = alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }

    public static byte[] decode(byte[] data) {
        int len = (data.length + 3) / 4 * 3;
        if (data.length > 0 && data[data.length - 1] == 61) {
            --len;
        }
        if (data.length > 1 && data[data.length - 2] == 61) {
            --len;
        }
        byte[] out = new byte[len];
        int shift = 0;
        int accum = 0;
        int index = 0;
        int ix = 0;
        while (ix < data.length) {
            byte value = codes[data[ix] & 0xFF];
            if (value >= 0) {
                accum <<= 6;
                accum |= value;
                if ((shift += 6) >= 8) {
                    out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
                }
            }
            ++ix;
        }
        if (index != out.length) {
            throw new RuntimeException("Error decoding BASE64 element: miscalculated data length!");
        }
        return out;
    }

    static {
        int i = 0;
        while (i < 256) {
            Base64.codes[i] = -1;
            ++i;
        }
        int i2 = 65;
        while (i2 <= 90) {
            Base64.codes[i2] = (byte)(i2 - 65);
            ++i2;
        }
        int i3 = 97;
        while (i3 <= 122) {
            Base64.codes[i3] = (byte)(26 + i3 - 97);
            ++i3;
        }
        int i4 = 48;
        while (i4 <= 57) {
            Base64.codes[i4] = (byte)(52 + i4 - 48);
            ++i4;
        }
        Base64.codes[43] = 62;
        Base64.codes[47] = 63;
    }
}

