/*
 * Decompiled with CFR 0.152.
 */
package helma.xmlrpc;

import helma.xmlrpc.XmlRpc;
import helma.xmlrpc.XmlRpcClient;
import helma.xmlrpc.XmlRpcClientLite;
import helma.xmlrpc.XmlRpcException;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;

public class Benchmark
implements Runnable {
    XmlRpcClient client = new XmlRpcClientLite(url);
    static String url;
    static int clients;
    int gCalls = 0;
    int gErrors = 0;
    Date date;

    public Benchmark() throws Exception {
        Vector<Integer> args = new Vector<Integer>();
        args.addElement(new Integer(123));
        this.client.execute("math.abs", args);
        this.date = new Date();
        this.date = new Date(this.date.getTime() / 1000L * 1000L);
        int i = 0;
        while (i < clients) {
            new Thread(this).start();
            ++i;
        }
    }

    public void run() {
        int errors = 0;
        int calls = 0;
        long start = System.currentTimeMillis();
        try {
            int val = (int)(-100.0 * Math.random());
            Vector<Integer> args = new Vector<Integer>();
            args.addElement(new Integer(val));
            int i = 0;
            while (i < 100) {
                Integer ret = (Integer)this.client.execute("math.abs", args);
                if (ret != Math.abs(val)) {
                    ++errors;
                }
                ++calls;
                ++i;
            }
        }
        catch (IOException x) {
            System.err.println("Exception in client: " + x);
            x.printStackTrace();
        }
        catch (XmlRpcException x) {
            System.err.println("Server reported error: " + x);
        }
        catch (Exception other) {
            System.err.println("Exception in Benchmark client: " + other);
        }
        int millis = (int)(System.currentTimeMillis() - start);
        this.checkout(calls, errors, millis);
    }

    private synchronized void checkout(int calls, int errors, int millis) {
        this.gCalls += calls;
        this.gErrors += errors;
        System.err.println("Benchmark thread finished: " + calls + " calls, " + errors + " errors in " + millis + " milliseconds.");
        if (--clients == 0) {
            System.err.println("");
            System.err.println("Benchmark result: " + 1000 * this.gCalls / millis + " calls per second.");
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0 && args.length < 3) {
            url = args[0];
            XmlRpc.setKeepAlive(true);
            if (args.length == 2) {
                XmlRpc.setDriver(args[1]);
            }
            new Benchmark();
        } else {
            System.err.println("Usage: java helma.xmlrpc.Benchmark URL [SAXDriver]");
        }
    }

    static {
        clients = 8;
    }
}

