/*
 * Decompiled with CFR 0.152.
 */
package helma.xmlrpc;

import helma.xmlrpc.XmlRpc;
import helma.xmlrpc.XmlRpcHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

class Invoker
implements XmlRpcHandler {
    private Object invokeTarget;
    private Class targetClass;

    public Invoker(Object target) {
        this.invokeTarget = target;
        Class<?> clazz = this.targetClass = this.invokeTarget instanceof Class ? (Class<?>)this.invokeTarget : this.invokeTarget.getClass();
        if (XmlRpc.debug) {
            System.err.println("Target object is " + this.targetClass);
        }
    }

    public Object execute(String methodName, Vector params) throws Exception {
        Class[] argClasses = null;
        Object[] argValues = null;
        if (params != null) {
            argClasses = new Class[params.size()];
            argValues = new Object[params.size()];
            int i = 0;
            while (i < params.size()) {
                argValues[i] = params.elementAt(i);
                argClasses[i] = argValues[i] instanceof Integer ? Integer.TYPE : (argValues[i] instanceof Double ? Double.TYPE : (argValues[i] instanceof Boolean ? Boolean.TYPE : argValues[i].getClass()));
                ++i;
            }
        }
        Method method = null;
        if (XmlRpc.debug) {
            System.err.println("Searching for method: " + methodName);
            int i = 0;
            while (i < argClasses.length) {
                System.err.println("Parameter " + i + ": " + argClasses[i] + " = " + argValues[i]);
                ++i;
            }
        }
        try {
            method = this.targetClass.getMethod(methodName, argClasses);
        }
        catch (NoSuchMethodException nsm_e) {
            throw nsm_e;
        }
        catch (SecurityException s_e) {
            throw s_e;
        }
        Object returnValue = null;
        try {
            returnValue = method.invoke(this.invokeTarget, argValues);
        }
        catch (IllegalAccessException iacc_e) {
            throw iacc_e;
        }
        catch (IllegalArgumentException iarg_e) {
            throw iarg_e;
        }
        catch (InvocationTargetException it_e) {
            if (XmlRpc.debug) {
                it_e.getTargetException().printStackTrace();
            }
            throw new Exception(it_e.getTargetException().toString());
        }
        return returnValue;
    }
}

