/*
 * Decompiled with CFR 0.152.
 */
package helma.xmlrpc;

import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import helma.xmlrpc.AuthDemo;
import helma.xmlrpc.Echo;
import helma.xmlrpc.WebServer;
import helma.xmlrpc.XmlRpc;
import helma.xmlrpc.XmlRpcClient;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class SecureWebServer
extends WebServer {
    protected String securityProviderClass;
    protected String keyStorePassphrase;
    protected String securityProtocol;
    protected String keyStoreFormat;
    protected String keyStoreLocation;
    protected String keyManagerType;
    protected String protocolHandlerPackages;
    protected static final String DEFAULT_SECURITY_PROVIDER_CLASS = "com.sun.net.ssl.internal.ssl.Provider";
    protected static final String DEFAULT_KEY_STORE_PASSPHRASE = "passphrase";
    protected static final String DEFAULT_SECURITY_PROTOCOL = "TLS";
    protected static final String DEFAULT_KEY_STORE_FORMAT = "JKS";
    protected static final String DEFAULT_KEY_STORE_LOCATION = "testkeys";
    protected static final String DEFAULT_KEY_MANAGER_TYPE = "SunX509";
    protected static final String DEFAULT_PROTOCOL_HANDLER_PACKAGES = "com.sun.net.ssl.internal.www.protocol";
    protected static final String PROTOCOL_HANDLER_PACKAGES_TAG = "java.protocol.handler.pkgs";
    static /* synthetic */ Class class$java$lang$Math;

    public SecureWebServer(int port) throws IOException {
        this(port, null);
    }

    public SecureWebServer(int port, InetAddress add) throws IOException {
        super(port, add);
    }

    public void setupServerSocket(int port, int backlog, InetAddress add) throws Exception {
        System.setProperty(PROTOCOL_HANDLER_PACKAGES_TAG, this.getProtocolHandlerPackages());
        Security.addProvider((Provider)Class.forName(this.getSecurityProviderClass()).newInstance());
        SSLContext context = SSLContext.getInstance((String)this.getSecurityProtocol());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance((String)this.getKeyManagerType());
        KeyStore keyStore = KeyStore.getInstance(this.getKeyStoreFormat());
        keyStore.load(new FileInputStream(this.getKeyStoreLocation()), this.getKeyStorePassphrase().toCharArray());
        keyManagerFactory.init(keyStore, this.getKeyStorePassphrase().toCharArray());
        context.init(keyManagerFactory.getKeyManagers(), null, null);
        SSLServerSocketFactory sslSrvFact = context.getServerSocketFactory();
        this.serverSocket = (SSLServerSocket)sslSrvFact.createServerSocket(port);
    }

    public void setSecurityProviderClass(String securityProviderClass) {
        this.securityProviderClass = securityProviderClass;
    }

    public String getSecurityProviderClass() {
        if (this.securityProviderClass == null) {
            return DEFAULT_SECURITY_PROVIDER_CLASS;
        }
        return this.securityProviderClass;
    }

    public void setKeyStorePassphrase(String keyStorePassphrase) {
        this.keyStorePassphrase = keyStorePassphrase;
    }

    public String getKeyStorePassphrase() {
        if (this.keyStorePassphrase == null) {
            return DEFAULT_KEY_STORE_PASSPHRASE;
        }
        return this.keyStorePassphrase;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public String getSecurityProtocol() {
        if (this.securityProtocol == null) {
            return DEFAULT_SECURITY_PROTOCOL;
        }
        return this.securityProtocol;
    }

    public void setKeyStoreLocation(String keyStoreLocation) {
        this.keyStoreLocation = keyStoreLocation;
    }

    public String getKeyStoreLocation() {
        if (this.keyStoreLocation == null) {
            return DEFAULT_KEY_STORE_LOCATION;
        }
        return this.keyStoreLocation;
    }

    public void setKeyStoreFormat(String keyStoreFormat) {
        this.keyStoreFormat = keyStoreFormat;
    }

    public String getKeyStoreFormat() {
        if (this.keyStoreFormat == null) {
            return KeyStore.getDefaultType();
        }
        return this.keyStoreFormat;
    }

    public void setKeyManagerType(String keyManagerType) {
        this.keyManagerType = keyManagerType;
    }

    public String getKeyManagerType() {
        if (this.keyManagerType == null) {
            return DEFAULT_KEY_MANAGER_TYPE;
        }
        return this.keyManagerType;
    }

    public void setProtocolHandlerPackages(String protocolHandlerPackages) {
        this.protocolHandlerPackages = protocolHandlerPackages;
    }

    public String getProtocolHandlerPackages() {
        if (this.protocolHandlerPackages == null) {
            return DEFAULT_PROTOCOL_HANDLER_PACKAGES;
        }
        return this.protocolHandlerPackages;
    }

    public static void main(String[] args) {
        System.err.println("Usage: java helma.xmlrpc.SecureWebServer [port]");
        int p = 10000;
        if (args.length > 0) {
            try {
                p = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfx) {
                System.err.println("Error parsing port number: " + args[0]);
            }
        }
        XmlRpc.setKeepAlive(true);
        try {
            SecureWebServer webserver = new SecureWebServer(p);
            webserver.addHandler("string", "Welcome to XML-RPC!");
            webserver.addHandler("math", class$java$lang$Math == null ? (class$java$lang$Math = SecureWebServer.class$("java.lang.Math")) : class$java$lang$Math);
            webserver.addHandler("auth", new AuthDemo());
            webserver.addHandler("$default", new Echo());
            webserver.addHandler("mttf", new XmlRpcClient("http://www.mailtothefuture.com:80/RPC2"));
            System.err.println("started web server on port " + p);
        }
        catch (IOException x) {
            System.err.println("Error creating web server: " + x);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

