/*
 * Decompiled with CFR 0.152.
 */
package helma.xmlrpc;

import helma.xmlrpc.AuthDemo;
import helma.xmlrpc.Base64;
import helma.xmlrpc.Echo;
import helma.xmlrpc.ServerInputStream;
import helma.xmlrpc.XmlRpc;
import helma.xmlrpc.XmlRpcClient;
import helma.xmlrpc.XmlRpcServer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class WebServer
implements Runnable {
    protected XmlRpcServer xmlrpc;
    protected ServerSocket serverSocket;
    protected int port;
    protected Thread listener;
    protected boolean paranoid;
    protected Vector accept;
    protected Vector deny;
    protected Stack threadpool;
    protected ThreadGroup runners;
    protected static final byte[] ctype = "Content-Type: text/xml\r\n".getBytes();
    protected static final byte[] clength = "Content-Length: ".getBytes();
    protected static final byte[] newline = "\r\n".getBytes();
    protected static final byte[] doubleNewline = "\r\n\r\n".getBytes();
    protected static final byte[] conkeep = "Connection: Keep-Alive\r\n".getBytes();
    protected static final byte[] conclose = "Connection: close\r\n".getBytes();
    protected static final byte[] ok = " 200 OK\r\n".getBytes();
    protected static final byte[] server = "Server: Helma XML-RPC 1.0\r\n".getBytes();
    static /* synthetic */ Class class$java$lang$Math;

    public static void main(String[] args) {
        System.err.println("Usage: java helma.xmlrpc.WebServer [port]");
        int p = 8080;
        if (args.length > 0) {
            try {
                p = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfx) {
                System.err.println("Error parsing port number: " + args[0]);
            }
        }
        XmlRpc.setKeepAlive(true);
        try {
            WebServer webserver = new WebServer(p);
            webserver.addHandler("string", "Welcome to XML-RPC!");
            webserver.addHandler("math", class$java$lang$Math == null ? (class$java$lang$Math = WebServer.class$("java.lang.Math")) : class$java$lang$Math);
            webserver.addHandler("auth", new AuthDemo());
            webserver.addHandler("$default", new Echo());
            webserver.addHandler("mttf", new XmlRpcClient("http://www.mailtothefuture.com:80/RPC2"));
            System.err.println("started web server on port " + p);
        }
        catch (IOException x) {
            System.err.println("Error creating web server: " + x);
        }
    }

    public WebServer(int port) throws IOException {
        this(port, null);
    }

    public WebServer(int port, InetAddress add) throws IOException {
        this.port = port;
        this.xmlrpc = new XmlRpcServer();
        this.accept = new Vector();
        this.deny = new Vector();
        this.threadpool = new Stack();
        this.runners = new ThreadGroup("XML-RPC Runner");
        try {
            this.setupServerSocket(port, 50, add);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        this.start();
    }

    public void setupServerSocket(int port, int x, InetAddress add) throws Exception {
        this.serverSocket = new ServerSocket(port, x, add);
    }

    public void start() {
        this.listener = new Thread((Runnable)this, "XML-RPC Weblistener");
        this.listener.start();
    }

    public void addHandler(String name, Object target) {
        this.xmlrpc.addHandler(name, target);
    }

    public void removeHandler(String name) {
        this.xmlrpc.removeHandler(name);
    }

    public void setParanoid(boolean p) {
        this.paranoid = p;
    }

    public void acceptClient(String address) throws IllegalArgumentException {
        try {
            AddressMatcher m = new AddressMatcher(address);
            this.accept.addElement(m);
        }
        catch (Exception x) {
            throw new IllegalArgumentException("\"" + address + "\" does not represent a valid IP address");
        }
    }

    public void denyClient(String address) throws IllegalArgumentException {
        try {
            AddressMatcher m = new AddressMatcher(address);
            this.deny.addElement(m);
        }
        catch (Exception x) {
            throw new IllegalArgumentException("\"" + address + "\" does not represent a valid IP address");
        }
    }

    protected boolean checkSocket(Socket s) {
        int l = this.deny.size();
        byte[] address = s.getInetAddress().getAddress();
        int i = 0;
        while (i < l) {
            AddressMatcher match = (AddressMatcher)this.deny.elementAt(i);
            if (match.matches(address)) {
                return false;
            }
            ++i;
        }
        l = this.accept.size();
        int i2 = 0;
        while (i2 < l) {
            AddressMatcher match = (AddressMatcher)this.accept.elementAt(i2);
            if (match.matches(address)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                while (this.listener != null) {
                    try {
                        socket = this.serverSocket.accept();
                        if (!this.paranoid || this.checkSocket(socket)) {
                            runner = this.getRunner();
                            runner.handle(socket);
                            continue;
                        }
                        socket.close();
                    }
                    catch (Exception ex) {
                        System.err.println("Exception in XML-RPC listener loop (" + ex + ").");
                    }
                    catch (Error err) {
                        System.err.println("Error in XML-RPC listener loop (" + err + ").");
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Error accepting XML-RPC connections (" + exception + ").");
                var4_7 = null;
                System.err.println("Closing XML-RPC server socket.");
                try {
                    this.serverSocket.close();
                    this.serverSocket = null;
                    return;
                }
                catch (IOException ignore) {
                    return;
                }
            }
            var4_6 = null;
            System.err.println("Closing XML-RPC server socket.");
        }
        catch (Throwable var3_12) {
            var4_8 = null;
            System.err.println("Closing XML-RPC server socket.");
            ** try [egrp 3[TRYBLOCK] [4 : 177->192)] { 
lbl38:
            // 1 sources

            this.serverSocket.close();
            this.serverSocket = null;
            throw var3_12;
lbl41:
            // 1 sources

            catch (IOException ignore) {
                // empty catch block
            }
            throw var3_12;
        }
        try {}
        catch (IOException ignore) {}
        this.serverSocket.close();
        this.serverSocket = null;
        return;
    }

    public void shutdown() {
        if (this.listener != null) {
            Thread l = this.listener;
            this.listener = null;
            l.interrupt();
        }
    }

    protected Runner getRunner() {
        try {
            return (Runner)this.threadpool.pop();
        }
        catch (EmptyStackException empty) {
            if (this.runners.activeCount() > 255) {
                throw new RuntimeException("System overload");
            }
            return new Runner();
        }
    }

    void releaseRunner(Runner runner) {
        this.threadpool.push(runner);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class AddressMatcher {
        int[] pattern = new int[4];

        public AddressMatcher(String address) throws Exception {
            StringTokenizer st = new StringTokenizer(address, ".");
            if (st.countTokens() != 4) {
                throw new Exception("\"" + address + "\" does not represent a valid IP address");
            }
            int i = 0;
            while (i < 4) {
                String next = st.nextToken();
                this.pattern[i] = "*".equals(next) ? 256 : (int)((byte)Integer.parseInt(next));
                ++i;
            }
        }

        public boolean matches(byte[] address) {
            int i = 0;
            while (i < 4) {
                if (this.pattern[i] <= 255 && this.pattern[i] != address[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    class Connection
    implements Runnable {
        private Socket socket;
        private BufferedInputStream input;
        private BufferedOutputStream output;
        private long lastRequest;
        private String user;
        private String password;
        byte[] buffer;

        public Connection(Socket socket) throws IOException {
            socket.setSoTimeout(30000);
            this.socket = socket;
            this.input = new BufferedInputStream(socket.getInputStream());
            this.output = new BufferedOutputStream(socket.getOutputStream());
        }

        /*
         * Loose catch block
         */
        public void run() {
            block19: {
                boolean keepalive = false;
                do {
                    this.password = null;
                    this.user = null;
                    String line = this.readLine();
                    if ("".equals(line)) {
                        line = this.readLine();
                    }
                    if (XmlRpc.debug) {
                        System.err.println(line);
                    }
                    this.lastRequest = System.currentTimeMillis();
                    int contentLength = -1;
                    StringTokenizer tokens = new StringTokenizer(line);
                    String method = tokens.nextToken();
                    String uri = tokens.nextToken();
                    String httpversion = tokens.nextToken();
                    boolean bl = keepalive = XmlRpc.getKeepAlive() && "HTTP/1.1".equals(httpversion);
                    do {
                        String lineLower;
                        if ((line = this.readLine()) == null) continue;
                        if (XmlRpc.debug) {
                            System.err.println(line);
                        }
                        if ((lineLower = line.toLowerCase()).startsWith("content-length:")) {
                            contentLength = Integer.parseInt(line.substring(15).trim());
                        }
                        if (lineLower.startsWith("connection:")) {
                            boolean bl2 = keepalive = XmlRpc.getKeepAlive() && lineLower.indexOf("keep-alive") > -1;
                        }
                        if (!lineLower.startsWith("authorization: basic ")) continue;
                        this.parseAuth(line);
                    } while (line != null && !line.equals(""));
                    if ("POST".equalsIgnoreCase(method)) {
                        ServerInputStream sin = new ServerInputStream(this.input, contentLength);
                        byte[] result = WebServer.this.xmlrpc.execute(sin, this.user, this.password);
                        this.output.write(httpversion.getBytes());
                        this.output.write(ok);
                        this.output.write(server);
                        if (keepalive) {
                            this.output.write(conkeep);
                        } else {
                            this.output.write(conclose);
                        }
                        this.output.write(ctype);
                        this.output.write(clength);
                        this.output.write(Integer.toString(result.length).getBytes());
                        this.output.write(doubleNewline);
                        this.output.write(result);
                        this.output.flush();
                        continue;
                    }
                    this.output.write(httpversion.getBytes());
                    this.output.write(" 400 Bad Request\r\n".getBytes());
                    this.output.write("Server: helma.XML-RPC\r\n\r\n".getBytes());
                    this.output.write(("Method " + method + " not implemented (try POST)").getBytes());
                    this.output.flush();
                    keepalive = false;
                } while (keepalive);
                Object var11_11 = null;
                try {
                    this.socket.close();
                }
                catch (IOException ignore) {}
                break block19;
                {
                    catch (Exception exception) {
                        if (XmlRpc.debug) {
                            System.err.println(exception);
                            exception.printStackTrace();
                        }
                        Object var11_12 = null;
                        try {
                            this.socket.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    try {
                        this.socket.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }

        private String readLine() throws IOException {
            int next;
            if (this.buffer == null) {
                this.buffer = new byte[512];
            }
            int count = 0;
            while ((next = this.input.read()) >= 0 && next != 10) {
                if (next != 13) {
                    this.buffer[count++] = (byte)next;
                }
                if (count < 512) continue;
                throw new IOException("HTTP Header too long");
            }
            return new String(this.buffer, 0, count);
        }

        private void parseAuth(String line) {
            try {
                byte[] c = Base64.decode(line.substring(21).getBytes());
                String str = new String(c);
                int col = str.indexOf(":");
                this.user = str.substring(0, col);
                this.password = str.substring(col + 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class Runner
    implements Runnable {
        Thread thread;
        Connection con;
        int count;

        Runner() {
        }

        public synchronized void handle(Socket socket) throws IOException {
            this.con = new Connection(socket);
            this.count = 0;
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = new Thread(WebServer.this.runners, this);
                this.thread.start();
            } else {
                this.notify();
            }
        }

        public void run() {
            while (Thread.currentThread() == this.thread) {
                this.con.run();
                ++this.count;
                this.con = null;
                if (this.count > 200 || WebServer.this.threadpool.size() > 20) {
                    return;
                }
                Runner runner = this;
                synchronized (runner) {
                    WebServer.this.releaseRunner(this);
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ir) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }
}

