/*
 * Decompiled with CFR 0.152.
 */
package helma.xmlrpc;

import helma.xmlrpc.Base64;
import helma.xmlrpc.Formatter;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XmlRpc
extends HandlerBase {
    public static final String version = "helma XML-RPC 1.0";
    String methodName;
    private static Class parserClass;
    private static Hashtable saxDrivers;
    Stack values;
    Value currentValue;
    static Formatter dateformat;
    StringBuffer cdata;
    boolean readCdata;
    static final int STRING = 0;
    static final int INTEGER = 1;
    static final int BOOLEAN = 2;
    static final int DOUBLE = 3;
    static final int DATE = 4;
    static final int BASE64 = 5;
    static final int STRUCT = 6;
    static final int ARRAY = 7;
    static final int NIL = 8;
    int errorLevel;
    String errorMsg;
    static final int NONE = 0;
    static final int RECOVERABLE = 1;
    static final int FATAL = 2;
    static boolean keepalive;
    public static boolean debug;
    static final String[] types;
    static String encoding;
    static Properties encodings;

    public static void setDriver(String driver) throws ClassNotFoundException {
        String parserClassName = null;
        try {
            parserClassName = (String)saxDrivers.get(driver);
            if (parserClassName == null) {
                parserClassName = driver;
            }
            parserClass = Class.forName(parserClassName);
        }
        catch (ClassNotFoundException x) {
            throw new ClassNotFoundException("SAX driver not found: " + parserClassName);
        }
    }

    public static void setDriver(Class driver) {
        parserClass = driver;
    }

    public static void setEncoding(String enc) {
        encoding = enc;
    }

    public String getEncoding() {
        return encodings.getProperty(encoding, encoding);
    }

    public static void setDebug(boolean val) {
        debug = val;
    }

    public static void setKeepAlive(boolean val) {
        keepalive = val;
    }

    public static boolean getKeepAlive() {
        return keepalive;
    }

    synchronized void parse(InputStream is) throws Exception {
        this.errorLevel = 0;
        this.errorMsg = null;
        this.values = new Stack();
        if (this.cdata == null) {
            this.cdata = new StringBuffer(128);
        } else {
            this.cdata.setLength(0);
        }
        this.readCdata = false;
        this.currentValue = null;
        long now = System.currentTimeMillis();
        if (parserClass == null) {
            XmlRpc.setDriver(System.getProperty("sax.driver", "org.apache.xerces.parsers.SAXParser"));
        }
        Parser parser = null;
        try {
            parser = (Parser)parserClass.newInstance();
        }
        catch (NoSuchMethodError nsm) {
            throw new Exception("Can't create Parser: " + parserClass);
        }
        parser.setDocumentHandler(this);
        parser.setErrorHandler(this);
        parser.parse(new InputSource(is));
        if (debug) {
            System.err.println("Spent " + (System.currentTimeMillis() - now) + " millis parsing");
        }
    }

    void writeObject(Object what, XmlWriter writer) {
        writer.startElement("value");
        if (what == null) {
            writer.emptyElement("nil");
        } else if (what instanceof String) {
            writer.chardata(what.toString());
        } else if (what instanceof Integer) {
            writer.startElement("int");
            writer.write(what.toString());
            writer.endElement("int");
        } else if (what instanceof Boolean) {
            writer.startElement("boolean");
            writer.write((Boolean)what != false ? "1" : "0");
            writer.endElement("boolean");
        } else if (what instanceof Double || what instanceof Float) {
            writer.startElement("double");
            writer.write(what.toString());
            writer.endElement("double");
        } else if (what instanceof Date) {
            writer.startElement("dateTime.iso8601");
            Date d = (Date)what;
            writer.write(dateformat.format(d));
            writer.endElement("dateTime.iso8601");
        } else if (what instanceof byte[]) {
            writer.startElement("base64");
            writer.write(Base64.encode((byte[])what));
            writer.endElement("base64");
        } else if (what instanceof Vector) {
            writer.startElement("array");
            writer.startElement("data");
            Vector v = (Vector)what;
            int l2 = v.size();
            int i2 = 0;
            while (i2 < l2) {
                this.writeObject(v.elementAt(i2), writer);
                ++i2;
            }
            writer.endElement("data");
            writer.endElement("array");
        } else if (what instanceof Hashtable) {
            writer.startElement("struct");
            Hashtable h = (Hashtable)what;
            Enumeration e = h.keys();
            while (e.hasMoreElements()) {
                String nextkey = (String)e.nextElement();
                Object nextval = h.get(nextkey);
                writer.startElement("member");
                writer.startElement("name");
                writer.write(nextkey);
                writer.endElement("name");
                this.writeObject(nextval, writer);
                writer.endElement("member");
            }
            writer.endElement("struct");
        } else {
            throw new RuntimeException("unsupported Java type: " + what.getClass());
        }
        writer.endElement("value");
    }

    abstract void objectParsed(Object var1);

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.readCdata) {
            return;
        }
        this.cdata.append(ch, start, length);
    }

    public void endElement(String name) throws SAXException {
        int depth;
        if (debug) {
            System.err.println("endElement: " + name);
        }
        if (this.currentValue != null && this.readCdata) {
            this.currentValue.characterData(this.cdata.toString());
            this.cdata.setLength(0);
            this.readCdata = false;
        }
        if ("value".equals(name) && ((depth = this.values.size()) < 2 || this.values.elementAt(depth - 2).hashCode() != 6)) {
            Value v = this.currentValue;
            this.values.pop();
            if (depth < 2) {
                this.objectParsed(v.value);
                this.currentValue = null;
            } else {
                this.currentValue = (Value)this.values.peek();
                this.currentValue.endElement(v);
            }
        }
        if ("member".equals(name)) {
            Value v = this.currentValue;
            this.values.pop();
            this.currentValue = (Value)this.values.peek();
            this.currentValue.endElement(v);
        } else if ("methodName".equals(name)) {
            this.methodName = this.cdata.toString();
            this.cdata.setLength(0);
            this.readCdata = false;
        }
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        if (debug) {
            System.err.println("startElement: " + name);
        }
        if ("value".equals(name)) {
            Value v = new Value();
            this.values.push(v);
            this.currentValue = v;
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("methodName".equals(name)) {
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("name".equals(name)) {
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("string".equals(name)) {
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("i4".equals(name) || "int".equals(name)) {
            this.currentValue.setType(1);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("boolean".equals(name)) {
            this.currentValue.setType(2);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("double".equals(name)) {
            this.currentValue.setType(3);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("dateTime.iso8601".equals(name)) {
            this.currentValue.setType(4);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("base64".equals(name)) {
            this.currentValue.setType(5);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("struct".equals(name)) {
            this.currentValue.setType(6);
        } else if ("array".equals(name)) {
            this.currentValue.setType(7);
        } else if ("nil".equals(name)) {
            this.currentValue.setType(8);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        System.err.println("Error parsing XML: " + e);
        this.errorLevel = 1;
        this.errorMsg = ((SAXException)e).toString();
    }

    public void fatalError(SAXParseException e) throws SAXException {
        System.err.println("Fatal error parsing XML: " + e);
        this.errorLevel = 2;
        this.errorMsg = ((SAXException)e).toString();
    }

    static {
        saxDrivers = new Hashtable();
        saxDrivers.put("xp", "com.jclark.xml.sax.Driver");
        saxDrivers.put("ibm1", "com.ibm.xml.parser.SAXDriver");
        saxDrivers.put("ibm2", "com.ibm.xml.parsers.SAXParser");
        saxDrivers.put("aelfred", "com.microstar.xml.SAXDriver");
        saxDrivers.put("oracle1", "oracle.xml.parser.XMLParser");
        saxDrivers.put("oracle2", "oracle.xml.parser.v2.SAXParser");
        saxDrivers.put("openxml", "org.openxml.parser.XMLSAXParser");
        dateformat = new Formatter();
        keepalive = false;
        debug = false;
        types = new String[]{"String", "Integer", "Boolean", "Double", "Date", "Base64", "Struct", "Array", "Nil"};
        encoding = "ISO8859_1";
        encodings = new Properties();
        ((Hashtable)encodings).put("UTF8", "UTF-8");
        ((Hashtable)encodings).put("ISO8859_1", "ISO-8859-1");
    }

    class XmlWriter {
        StringBuffer buf;
        String enc;

        public XmlWriter(StringBuffer buf) {
            this(buf, encoding);
        }

        public XmlWriter(StringBuffer buf, String enc) {
            this.buf = buf;
            this.enc = enc;
            String encName = encodings.getProperty(enc, enc);
            buf.append("<?xml version=\"1.0\" encoding=\"" + encName + "\"?>");
        }

        public void startElement(String elem) {
            this.buf.append("<");
            this.buf.append(elem);
            this.buf.append(">");
        }

        public void endElement(String elem) {
            this.buf.append("</");
            this.buf.append(elem);
            this.buf.append(">");
        }

        public void emptyElement(String elem) {
            this.buf.append("<");
            this.buf.append(elem);
            this.buf.append("/>");
        }

        public void chardata(String text) {
            int l = text.length();
            int i = 0;
            while (i < l) {
                char c = text.charAt(i);
                switch (c) {
                    case '<': {
                        this.buf.append("&lt;");
                        break;
                    }
                    case '&': {
                        this.buf.append("&amp;");
                        break;
                    }
                    default: {
                        this.buf.append(c);
                    }
                }
                ++i;
            }
        }

        public void write(char[] text) {
            this.buf.append(text);
        }

        public void write(String text) {
            this.buf.append(text);
        }

        public String toString() {
            return this.buf.toString();
        }

        public byte[] getBytes() throws UnsupportedEncodingException {
            return this.buf.toString().getBytes(this.enc);
        }
    }

    class Value {
        int type = 0;
        Object value;
        String nextMemberName;
        Hashtable struct;
        Vector array;

        public void endElement(Value child) {
            if (this.type == 7) {
                this.array.addElement(child.value);
            } else if (this.type == 6) {
                this.struct.put(this.nextMemberName, child.value);
            }
        }

        public void setType(int type) {
            this.type = type;
            if (type == 7) {
                this.value = this.array = new Vector();
            }
            if (type == 6) {
                this.value = this.struct = new Hashtable();
            }
        }

        public void characterData(String cdata) {
            switch (this.type) {
                case 1: {
                    this.value = new Integer(cdata.trim());
                    break;
                }
                case 2: {
                    this.value = new Boolean("1".equals(cdata.trim()));
                    break;
                }
                case 3: {
                    this.value = new Double(cdata.trim());
                    break;
                }
                case 4: {
                    try {
                        this.value = dateformat.parse(cdata.trim());
                        break;
                    }
                    catch (ParseException p) {
                        throw new RuntimeException(p.getMessage());
                    }
                }
                case 5: {
                    this.value = Base64.decode(cdata.getBytes());
                    break;
                }
                case 0: {
                    this.value = cdata;
                    break;
                }
                case 6: {
                    this.nextMemberName = cdata;
                }
            }
        }

        public int hashCode() {
            return this.type;
        }

        public String toString() {
            return types[this.type] + " element " + this.value;
        }
    }
}

