/*
 * Decompiled with CFR 0.152.
 */
package helma.xmlrpc;

import helma.xmlrpc.Base64;
import helma.xmlrpc.XmlRpc;
import helma.xmlrpc.XmlRpcException;
import helma.xmlrpc.XmlRpcHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class XmlRpcClient
implements XmlRpcHandler {
    URL url;
    String auth;
    Stack pool = new Stack();
    int workers = 0;

    public XmlRpcClient(URL url) {
        this.url = url;
    }

    public XmlRpcClient(String url) throws MalformedURLException {
        this.url = new URL(url);
    }

    public XmlRpcClient(String hostname, int port) throws MalformedURLException {
        this.url = new URL("http://" + hostname + ":" + port + "/RPC2");
    }

    public void setBasicAuthentication(String user, String password) {
        if (user == null || password == null) {
            this.auth = null;
        } else {
            char[] basicAuth = Base64.encode((user + ":" + password).getBytes());
            this.auth = new String(basicAuth).trim();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(String method, Vector params) throws XmlRpcException, IOException {
        Object object;
        block3: {
            Worker worker = this.getWorker();
            try {
                Object retval;
                object = retval = worker.execute(method, params);
                Object var7_6 = null;
                if (this.workers >= 50 || worker.fault) break block3;
                this.pool.push(worker);
                return object;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (this.workers < 50 && !worker.fault) {
                    this.pool.push(worker);
                    throw throwable;
                }
                --this.workers;
                throw throwable;
            }
        }
        --this.workers;
        return object;
    }

    private final Worker getWorker() throws IOException {
        try {
            return (Worker)this.pool.pop();
        }
        catch (EmptyStackException x) {
            if (this.workers < 100) {
                ++this.workers;
                return new Worker();
            }
            throw new IOException("XML-RPC System overload");
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            String url = args[0];
            String method = args[1];
            Vector<Object> v = new Vector<Object>();
            int i = 2;
            while (i < args.length) {
                try {
                    v.addElement(new Integer(Integer.parseInt(args[i])));
                }
                catch (NumberFormatException nfx) {
                    v.addElement(args[i]);
                }
                ++i;
            }
            XmlRpcClient client = new XmlRpcClient(url);
            try {
                System.err.println(client.execute(method, v));
            }
            catch (Exception ex) {
                System.err.println("Error: " + ex.getMessage());
            }
        }
        catch (Exception x) {
            System.err.println(x);
            System.err.println("Usage: java helma.xmlrpc.XmlRpcClient <url> <method> <arg> ....");
            System.err.println("Arguments are sent as integers or strings.");
        }
    }

    class Worker
    extends XmlRpc {
        boolean fault;
        Object result = null;
        StringBuffer strbuf;

        public Object execute(String method, Vector params) throws XmlRpcException, IOException {
            this.fault = false;
            long now = System.currentTimeMillis();
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                if (this.strbuf == null) {
                    this.strbuf = new StringBuffer();
                } else {
                    this.strbuf.setLength(0);
                }
                XmlRpc.XmlWriter writer = new XmlRpc.XmlWriter(this, this.strbuf);
                this.writeRequest(writer, method, params);
                byte[] request = writer.getBytes();
                URLConnection con = XmlRpcClient.this.url.openConnection();
                con.setDoInput(true);
                con.setDoOutput(true);
                con.setUseCaches(false);
                con.setAllowUserInteraction(false);
                con.setRequestProperty("Content-Length", Integer.toString(request.length));
                con.setRequestProperty("Content-Type", "text/xml");
                if (XmlRpcClient.this.auth != null) {
                    con.setRequestProperty("Authorization", "Basic " + XmlRpcClient.this.auth);
                }
                OutputStream out = con.getOutputStream();
                out.write(request);
                out.flush();
                InputStream in = con.getInputStream();
                this.parse(in);
            }
            catch (Exception x) {
                throw new IOException(x.getMessage());
            }
            if (this.fault) {
                XmlRpcException exception = null;
                try {
                    Hashtable f = (Hashtable)this.result;
                    String faultString = (String)f.get("faultString");
                    int faultCode = Integer.parseInt(f.get("faultCode").toString());
                    exception = new XmlRpcException(faultCode, faultString.trim());
                }
                catch (Exception x) {
                    throw new XmlRpcException(0, "Invalid fault response");
                }
                throw exception;
            }
            if (XmlRpc.debug) {
                System.err.println("Spent " + (System.currentTimeMillis() - now) + " in request");
            }
            return this.result;
        }

        void objectParsed(Object what) {
            this.result = what;
        }

        void writeRequest(XmlRpc.XmlWriter writer, String method, Vector params) throws IOException {
            writer.startElement("methodCall");
            writer.startElement("methodName");
            writer.write(method);
            writer.endElement("methodName");
            writer.startElement("params");
            int l = params.size();
            int i = 0;
            while (i < l) {
                writer.startElement("param");
                this.writeObject(params.elementAt(i), writer);
                writer.endElement("param");
                ++i;
            }
            writer.endElement("params");
            writer.endElement("methodCall");
        }

        public void startElement(String name, AttributeList atts) throws SAXException {
            if ("fault".equals(name)) {
                this.fault = true;
            } else {
                super.startElement(name, atts);
            }
        }
    }
}

