/*
 * Decompiled with CFR 0.152.
 */
package helma.xmlrpc;

import helma.xmlrpc.ServerInputStream;
import helma.xmlrpc.XmlRpc;
import helma.xmlrpc.XmlRpcClient;
import helma.xmlrpc.XmlRpcException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class XmlRpcClientLite
extends XmlRpcClient {
    Stack pool = new Stack();
    int workers = 0;

    public XmlRpcClientLite(URL url) {
        super(url);
    }

    public XmlRpcClientLite(String url) throws MalformedURLException {
        super(url);
    }

    public XmlRpcClientLite(String hostname, int port) throws MalformedURLException {
        super(hostname, port);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(String method, Vector params) throws XmlRpcException, IOException {
        Object object;
        block3: {
            Worker worker = this.getWorker();
            try {
                Object retval;
                object = retval = worker.execute(method, params);
                Object var7_6 = null;
                if (this.workers >= 50 || worker.fault) break block3;
                this.pool.push(worker);
                return object;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (this.workers < 50 && !worker.fault) {
                    this.pool.push(worker);
                    throw throwable;
                }
                --this.workers;
                throw throwable;
            }
        }
        --this.workers;
        return object;
    }

    private final Worker getWorker() throws IOException {
        try {
            return (Worker)this.pool.pop();
        }
        catch (EmptyStackException x) {
            if (this.workers < 100) {
                ++this.workers;
                return new Worker();
            }
            throw new IOException("XML-RPC System overload");
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            String url = args[0];
            String method = args[1];
            Vector<Object> v = new Vector<Object>();
            int i = 2;
            while (i < args.length) {
                try {
                    v.addElement(new Integer(Integer.parseInt(args[i])));
                }
                catch (NumberFormatException nfx) {
                    v.addElement(args[i]);
                }
                ++i;
            }
            XmlRpcClientLite client = new XmlRpcClientLite(url);
            try {
                System.err.println(((XmlRpcClient)client).execute(method, v));
            }
            catch (Exception ex) {
                System.err.println("Error: " + ex.getMessage());
            }
        }
        catch (Exception x) {
            System.err.println(x);
            System.err.println("Usage: java helma.xmlrpc.XmlRpcClient <url> <method> <arg> ....");
            System.err.println("Arguments are sent as integers or strings.");
        }
    }

    class HttpClient {
        String hostname;
        String host;
        int port;
        String uri;
        Socket socket = null;
        BufferedOutputStream output;
        BufferedInputStream input;
        boolean keepalive;
        boolean fresh;
        byte[] buffer;

        public HttpClient(URL url) throws IOException {
            this.hostname = url.getHost();
            this.port = url.getPort();
            if (this.port < 1) {
                this.port = 80;
            }
            this.uri = url.getFile();
            if (this.uri == null || "".equals(this.uri)) {
                this.uri = "/";
            }
            this.host = this.port == 80 ? this.hostname : this.hostname + ":" + this.port;
            this.initConnection();
        }

        protected void initConnection() throws IOException {
            this.fresh = true;
            this.socket = new Socket(this.hostname, this.port);
            this.output = new BufferedOutputStream(this.socket.getOutputStream());
            this.input = new BufferedInputStream(this.socket.getInputStream());
        }

        protected void closeConnection() {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void write(byte[] request) throws IOException {
            try {
                this.output.write(("POST " + this.uri + " HTTP/1.0\r\n").getBytes());
                this.output.write("User-Agent: helma XML-RPC 1.0\r\n".getBytes());
                this.output.write(("Host: " + this.host + "\r\n").getBytes());
                if (XmlRpc.getKeepAlive()) {
                    this.output.write("Connection: Keep-Alive\r\n".getBytes());
                }
                this.output.write("Content-Type: text/xml\r\n".getBytes());
                if (XmlRpcClientLite.this.auth != null) {
                    this.output.write(("Authorization: Basic " + XmlRpcClientLite.this.auth + "\r\n").getBytes());
                }
                this.output.write(("Content-Length: " + request.length).getBytes());
                this.output.write("\r\n\r\n".getBytes());
                this.output.write(request);
                this.output.flush();
                this.fresh = false;
            }
            catch (IOException iox) {
                if (!this.fresh) {
                    this.initConnection();
                    this.write(request);
                }
                throw iox;
            }
        }

        public InputStream getInputStream() throws IOException {
            String line = this.readLine();
            if (XmlRpc.debug) {
                System.err.println(line);
            }
            int contentLength = -1;
            try {
                StringTokenizer tokens = new StringTokenizer(line);
                String httpversion = tokens.nextToken();
                String statusCode = tokens.nextToken();
                String statusMsg = tokens.nextToken("\n\r");
                boolean bl = this.keepalive = XmlRpc.getKeepAlive() && "HTTP/1.1".equals(httpversion);
                if (!"200".equals(statusCode)) {
                    throw new IOException("Unexpected Response from Server: " + statusMsg);
                }
            }
            catch (IOException iox) {
                throw iox;
            }
            catch (Exception x) {
                x.printStackTrace();
                throw new IOException("Server returned invalid Response.");
            }
            do {
                if ((line = this.readLine()) == null) continue;
                if (XmlRpc.debug) {
                    System.err.println(line);
                }
                if ((line = line.toLowerCase()).startsWith("content-length:")) {
                    contentLength = Integer.parseInt(line.substring(15).trim());
                }
                if (!line.startsWith("connection:")) continue;
                boolean bl = this.keepalive = XmlRpc.getKeepAlive() && line.indexOf("keep-alive") > -1;
            } while (line != null && !line.equals(""));
            return new ServerInputStream(this.input, contentLength);
        }

        private String readLine() throws IOException {
            int next;
            if (this.buffer == null) {
                this.buffer = new byte[512];
            }
            int count = 0;
            while ((next = this.input.read()) >= 0 && next != 10) {
                if (next != 13) {
                    this.buffer[count++] = (byte)next;
                }
                if (count < 512) continue;
                throw new IOException("HTTP Header too long");
            }
            return new String(this.buffer, 0, count);
        }

        protected void finalize() throws Throwable {
            this.closeConnection();
        }
    }

    class Worker
    extends XmlRpc {
        boolean fault;
        Object result = null;
        HttpClient client = null;
        StringBuffer strbuf;

        public Object execute(String method, Vector params) throws XmlRpcException, IOException {
            long now = System.currentTimeMillis();
            this.fault = false;
            try {
                if (this.strbuf == null) {
                    this.strbuf = new StringBuffer();
                } else {
                    this.strbuf.setLength(0);
                }
                XmlRpc.XmlWriter writer = new XmlRpc.XmlWriter(this.strbuf);
                this.writeRequest(writer, method, params);
                byte[] request = writer.getBytes();
                if (this.client == null) {
                    this.client = new HttpClient(XmlRpcClientLite.this.url);
                }
                this.client.write(request);
                InputStream in = this.client.getInputStream();
                this.parse(in);
                if (!this.client.keepalive) {
                    this.client.closeConnection();
                }
                if (XmlRpc.debug) {
                    System.err.println("result = " + this.result);
                }
                if (this.errorLevel == 2) {
                    throw new Exception(this.errorMsg);
                }
            }
            catch (IOException iox) {
                throw iox;
            }
            catch (Exception x) {
                String msg;
                if (XmlRpc.debug) {
                    x.printStackTrace();
                }
                if ((msg = x.getMessage()) == null || msg.length() == 0) {
                    msg = x.toString();
                }
                throw new IOException(msg);
            }
            if (this.fault) {
                XmlRpcException exception = null;
                try {
                    Hashtable f = (Hashtable)this.result;
                    String faultString = (String)f.get("faultString");
                    int faultCode = Integer.parseInt(f.get("faultCode").toString());
                    exception = new XmlRpcException(faultCode, faultString.trim());
                }
                catch (Exception x) {
                    throw new XmlRpcException(0, "Server returned an invalid fault response.");
                }
                throw exception;
            }
            if (XmlRpc.debug) {
                System.err.println("Spent " + (System.currentTimeMillis() - now) + " millis in request");
            }
            return this.result;
        }

        void objectParsed(Object what) {
            this.result = what;
        }

        void writeRequest(XmlRpc.XmlWriter writer, String method, Vector params) throws IOException {
            writer.startElement("methodCall");
            writer.startElement("methodName");
            writer.write(method);
            writer.endElement("methodName");
            writer.startElement("params");
            int l = params.size();
            int i = 0;
            while (i < l) {
                writer.startElement("param");
                this.writeObject(params.elementAt(i), writer);
                writer.endElement("param");
                ++i;
            }
            writer.endElement("params");
            writer.endElement("methodCall");
        }

        public void startElement(String name, AttributeList atts) throws SAXException {
            if ("fault".equals(name)) {
                this.fault = true;
            } else {
                super.startElement(name, atts);
            }
        }
    }
}

