/*
 * Decompiled with CFR 0.152.
 */
package helma.xmlrpc;

import helma.xmlrpc.AuthenticatedXmlRpcHandler;
import helma.xmlrpc.Invoker;
import helma.xmlrpc.XmlRpc;
import helma.xmlrpc.XmlRpcException;
import helma.xmlrpc.XmlRpcHandler;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class XmlRpcServer {
    Hashtable handlers;
    Stack pool = new Stack();
    int workers = 0;

    public XmlRpcServer() {
        this.handlers = new Hashtable();
    }

    public void addHandler(String handlername, Object handler) {
        if (handler instanceof XmlRpcHandler || handler instanceof AuthenticatedXmlRpcHandler) {
            this.handlers.put(handlername, handler);
        } else if (handler != null) {
            this.handlers.put(handlername, new Invoker(handler));
        }
    }

    public void removeHandler(String handlername) {
        this.handlers.remove(handlername);
    }

    public byte[] execute(InputStream is) {
        return this.execute(is, null, null);
    }

    public byte[] execute(InputStream is, String user, String password) {
        Worker worker = this.getWorker();
        byte[] retval = worker.execute(is, user, password);
        this.pool.push(worker);
        return retval;
    }

    private final Worker getWorker() {
        try {
            return (Worker)this.pool.pop();
        }
        catch (EmptyStackException x) {
            if (this.workers < 100) {
                ++this.workers;
                return new Worker();
            }
            throw new RuntimeException("System overload");
        }
    }

    class Worker
    extends XmlRpc {
        Vector inParams;
        Object outParam;
        byte[] result;
        StringBuffer strbuf;

        Worker() {
        }

        public byte[] execute(InputStream is, String user, String password) {
            this.inParams = new Vector();
            if (this.strbuf == null) {
                this.strbuf = new StringBuffer();
            } else {
                this.strbuf.setLength(0);
            }
            long now = System.currentTimeMillis();
            try {
                this.parse(is);
                if (XmlRpc.debug) {
                    System.err.println("method name: " + this.methodName);
                    System.err.println("inparams: " + this.inParams);
                }
                if (this.errorLevel > 0) {
                    throw new Exception(this.errorMsg);
                }
                Object handler = null;
                String handlerName = null;
                int dot = this.methodName.indexOf(".");
                if (dot > -1 && (handler = XmlRpcServer.this.handlers.get(handlerName = this.methodName.substring(0, dot))) != null) {
                    this.methodName = this.methodName.substring(dot + 1);
                }
                if (handler == null) {
                    handler = XmlRpcServer.this.handlers.get("$default");
                }
                if (handler == null) {
                    if (dot > -1) {
                        throw new Exception("RPC handler object \"" + handlerName + "\" not found and no default handler registered.");
                    }
                    throw new Exception("RPC handler object not found for \"" + this.methodName + "\": no default handler registered.");
                }
                this.outParam = handler instanceof AuthenticatedXmlRpcHandler ? ((AuthenticatedXmlRpcHandler)handler).execute(this.methodName, this.inParams, user, password) : ((XmlRpcHandler)handler).execute(this.methodName, this.inParams);
                if (XmlRpc.debug) {
                    System.err.println("outparam = " + this.outParam);
                }
                XmlRpc.XmlWriter writer = new XmlRpc.XmlWriter(this.strbuf);
                this.writeResponse(this.outParam, writer);
                this.result = writer.getBytes();
            }
            catch (Exception x) {
                if (XmlRpc.debug) {
                    x.printStackTrace();
                }
                XmlRpc.XmlWriter writer = new XmlRpc.XmlWriter(this.strbuf);
                String message = x.toString();
                int code = x instanceof XmlRpcException ? ((XmlRpcException)x).code : 0;
                this.writeError(code, message, writer);
                try {
                    this.result = writer.getBytes();
                }
                catch (UnsupportedEncodingException encx) {
                    System.err.println("XmlRpcServer.execute: " + encx);
                    this.result = writer.toString().getBytes();
                }
            }
            if (XmlRpc.debug) {
                System.err.println("Spent " + (System.currentTimeMillis() - now) + " millis in request");
            }
            return this.result;
        }

        void objectParsed(Object what) {
            this.inParams.addElement(what);
        }

        void writeResponse(Object param, XmlRpc.XmlWriter writer) {
            writer.startElement("methodResponse");
            writer.startElement("params");
            writer.startElement("param");
            this.writeObject(param, writer);
            writer.endElement("param");
            writer.endElement("params");
            writer.endElement("methodResponse");
        }

        void writeError(int code, String message, XmlRpc.XmlWriter writer) {
            Hashtable<String, Object> h = new Hashtable<String, Object>();
            h.put("faultCode", new Integer(code));
            h.put("faultString", message);
            writer.startElement("methodResponse");
            writer.startElement("fault");
            this.writeObject(h, writer);
            writer.endElement("fault");
            writer.endElement("methodResponse");
        }
    }
}

