/*
 * Decompiled with CFR 0.152.
 */
package helma.xmlrpc.secure;

import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import helma.xmlrpc.AuthDemo;
import helma.xmlrpc.Echo;
import helma.xmlrpc.WebServer;
import helma.xmlrpc.XmlRpc;
import helma.xmlrpc.secure.SecurityConstants;
import helma.xmlrpc.secure.SecurityTool;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.KeyStore;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class SecureWebServer
extends WebServer
implements SecurityConstants {
    static /* synthetic */ Class class$java$lang$Math;

    public SecureWebServer(int port) throws IOException {
        this(port, null);
    }

    public SecureWebServer(int port, InetAddress add) throws IOException {
        super(port, add);
    }

    public void setupServerSocket(int port, int backlog, InetAddress add) throws Exception {
        SecurityTool.setup();
        SSLContext context = SSLContext.getInstance((String)SecurityTool.getSecurityProtocol());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance((String)SecurityTool.getKeyManagerType());
        KeyStore keyStore = KeyStore.getInstance(SecurityTool.getKeyStoreType());
        keyStore.load(new FileInputStream(SecurityTool.getKeyStore()), SecurityTool.getKeyStorePassword().toCharArray());
        keyManagerFactory.init(keyStore, SecurityTool.getKeyStorePassword().toCharArray());
        context.init(keyManagerFactory.getKeyManagers(), null, null);
        SSLServerSocketFactory sslSrvFact = context.getServerSocketFactory();
        this.serverSocket = (SSLServerSocket)sslSrvFact.createServerSocket(port);
    }

    public static void main(String[] args) {
        System.err.println("Usage: java helma.xmlrpc.SecureWebServer [port]");
        int p = 10000;
        if (args.length > 0) {
            try {
                p = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfx) {
                System.err.println("Error parsing port number: " + args[0]);
            }
        }
        XmlRpc.setKeepAlive(true);
        try {
            SecureWebServer webserver = new SecureWebServer(p);
            webserver.addHandler("string", "Welcome to XML-RPC!");
            webserver.addHandler("math", class$java$lang$Math == null ? (class$java$lang$Math = SecureWebServer.class$("java.lang.Math")) : class$java$lang$Math);
            webserver.addHandler("auth", new AuthDemo());
            webserver.addHandler("$default", new Echo());
            System.err.println("started web server on port " + p);
        }
        catch (IOException x) {
            System.err.println("Error creating web server: " + x);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

