/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.autoclose;

import java.io.Closeable;
import java.lang.ref.Reference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AutoCloser {
    private static final Logger logger = Logger.getLogger(AutoCloser.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private final Lock lock = new ReentrantLock();
    protected static AutoCloser instance;
    private Collection objects;
    private static Thread thread;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    protected AutoCloser() {
        this.initThread();
    }

    public static synchronized AutoCloser get() {
        if (instance != null) {
            return instance;
        }
        if (isLogFine) {
            AutoCloser.logFine("create AutoCloser instance", new Object[0]);
        }
        instance = new AutoCloser();
        return instance;
    }

    protected Collection objects() {
        try {
            this.lock.lock();
            if (this.objects != null) {
                Collection collection = this.objects;
                return collection;
            }
            this.objects = Collections.synchronizedSet(new LinkedHashSet());
            if (isLogFine) {
                AutoCloser.logFine("created collection for release objects", new Object[0]);
            }
            Collection collection = this.objects;
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void add(Object obj) {
        if (obj == null) {
            return;
        }
        if (isLogFine) {
            AutoCloser.logFine("add( {0} )", obj);
        }
        try {
            this.lock.lock();
            Collection c = this.objects();
            c.add(obj);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void remove(Object obj) {
        if (obj == null) {
            return;
        }
        if (isLogFine) {
            AutoCloser.logFine("remove( {0} )", obj);
        }
        try {
            this.lock.lock();
            Collection c = this.objects();
            c.remove(obj);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        try {
            if (isLogFine) {
                AutoCloser.logFine("closeAll( {0} )", new Object[0]);
            }
            this.lock.lock();
            Collection cobjs = this.objects();
            if (isLogFiner) {
                AutoCloser.logFiner("size of queue = {0}", cobjs.size());
            }
            int idx = 0;
            int cnt = cobjs.size();
            for (Object o : cobjs) {
                Object co;
                ++idx;
                if (o == null) continue;
                if (isLogFiner) {
                    AutoCloser.logFiner("{0}/{1} close", idx, cnt);
                }
                if ((co = o) instanceof Reference) {
                    co = ((Reference)co).get();
                }
                try {
                    if (co instanceof Closeable) {
                        ((Closeable)co).close();
                        continue;
                    }
                    if (co instanceof Runnable) {
                        ((Runnable)co).run();
                        continue;
                    }
                    if (co instanceof Connection) {
                        ((Connection)co).close();
                        continue;
                    }
                    if (co instanceof ResultSet) {
                        ((ResultSet)co).close();
                        continue;
                    }
                    if (!(co instanceof Statement)) continue;
                    ((Statement)co).close();
                }
                catch (Throwable err) {
                    if (!isLogSevere) continue;
                    logger.log(Level.SEVERE, "fail on close " + co, err);
                }
            }
            if (isLogFiner) {
                AutoCloser.logFiner("clear collection of release objects", new Object[0]);
            }
            cobjs.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void initThread() {
        if (thread != null) {
            return;
        }
        if (isLogFine) {
            AutoCloser.logFine("initThread", new Object[0]);
        }
        thread = new Thread(){

            @Override
            public void run() {
                AutoCloser.get().closeAll();
            }
        };
        thread.setName("AutoCloser");
        Runtime.getRuntime().addShutdownHook(thread);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

