/*
 * The MIT License
 *
 * Copyright 2015 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.cli;


import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.text.Text;

/**
 *
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class Declaration {
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(Declaration.class.getName());
    private static final Level logLevel = logger.getLevel();
    
    private static final boolean isLogSevere = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();
    
    private static final boolean isLogWarning = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();
    
    private static final boolean isLogInfo = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();
    
    private static final boolean isLogFine = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();
    
    private static final boolean isLogFiner = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();
    
    private static final boolean isLogFinest = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    //</editor-fold>
    
    public Declaration(){
    }
    
    protected Memory memory;
    
    public Declaration( Memory mem ){
        this.memory = mem;
    }

    public Memory getMemory() {
        return memory;
    }

    public void setMemory(Memory memory) {
        this.memory = memory;
    }
    
    public String getTypeName( Class type ){
        if( type==null )return "void";

        String ttname = type.getName();
        if( type==Integer.class ){
            ttname = "Integer";
        }else if( type==Boolean.class ){
            ttname = "Boolean";
        }else if( type==String.class ){
            ttname = "String";
        }else if( type==int.class ){
            ttname = "int";
        }else if( type==boolean.class ){
            ttname = "boolean";
        }else if( type==Double.class ){
            ttname = "Double";
        }else if( type==double.class ){
            ttname = "double";
        }else if( type==Float.class ){
            ttname = "Float";
        }else if( type==float.class ){
            ttname = "float";
        }else if( type==Long.class ){
            ttname = "Long";
        }else if( type==long.class ){
            ttname = "long";
        }else if( type==Short.class ){
            ttname = "Short";
        }else if( type==short.class ){
            ttname = "short";
        }else if( type==Byte.class ){
            ttname = "Byte";
        }else if( type==byte.class ){
            ttname = "byte";
        }else if( type==Void.class ){
            ttname = "void";
        }
        
        return ttname;
    }
    
    public String getParamNameOf( Function fun, int paramIndex ){
        if( fun==null )throw new IllegalArgumentException( "fun==null" );
        
        Class[] paramTypes = fun.getParameters();
        if( paramTypes==null || paramTypes.length==0 )
            throw new IllegalArgumentException( "fun not has parameters" );
        
        if( paramIndex<0 )throw new IllegalArgumentException( "paramIndex<0" );
        if( paramIndex>=paramTypes.length )
            throw new IllegalArgumentException( 
                "paramIndex>=paramTypes.length("+paramTypes.length+")" );

        if( fun instanceof FunctionBuilder.MethodCall ){
            String[] namesOfparam = null;
            
            Method m = ((FunctionBuilder.MethodCall)fun).getMethod();
            Annotation[][] paramsAnn = m.getParameterAnnotations();
            namesOfparam =  new String[paramsAnn.length];
            for( int i1=0; i1<paramsAnn.length; i1++ ){
                for( Annotation a : paramsAnn[i1] ){
                    if( a instanceof Name ){
                        namesOfparam[i1] = ((Name)a).name();
                    }
                }
            }
            
            if( paramIndex>=0 && 
                namesOfparam!=null &&
                paramIndex<namesOfparam.length && 
                namesOfparam[paramIndex]!=null 
            ){
                return namesOfparam[paramIndex];
            }
        }
        
        return "arg"+paramIndex;
    }
    
    public String getDeclareOf( Function fun ){
        if( fun==null )return "!null argument";
        if( fun instanceof IsOperator && ((IsOperator)fun).isOperator() ){
            return getDeclareOfOperator(fun);
        }
        return getDeclareOfCommand(fun);
    }
    
    protected String getDeclareOfOperator( Function fun ){
        Class[] paramTypes = fun.getParameters();
        Class retType = fun.getReturn();
        
        String firstParam = paramTypes.length>0 
            ? getTypeName(paramTypes[0])
            : "";
        
        String secondParam = paramTypes.length>1
            ? getParamNameOf(fun, 1) + " : " + getTypeName(paramTypes[1])
            : "";
        
        String retValue = getTypeName(retType);
        boolean retIsVoid = retType==null || retType==Void.class || retType.getName().equals("void");
        
        String funName = fun.toString();
        if( memory!=null ){
            String n = memory.getNameOf(fun);
            if( n!=null && n.length()>0 ){
                funName = Text.trimStart(n,memory.getOperatorPrefix());
            }
        }
        
        // binary operator
        if( paramTypes.length==2 ){
            if( retIsVoid ){
//                return firstParam+" "+funName+" ("+secondParam+")";
                return funName+" ("+secondParam+")";
            }else{
//                return firstParam+" "+funName+" ("+secondParam+") : "+retValue;
                return funName+" ("+secondParam+") : "+retValue;
            }
        }else if( paramTypes.length==1 ){
            if( retIsVoid ){
                return funName;
            }else{
//                return firstParam+" "+funName+" : "+retValue;
                return funName+" : "+retValue;
            }
        }else{
            return getDeclareOfCommand(fun);
        }
    }
    
    protected String getDeclareOfCommand( Function fun ){
        StringBuilder fundecl = new StringBuilder();
        if( fun!=null ){
            Class[] paramTypes = fun.getParameters();
            if( paramTypes.length>0 ){
                fundecl.append("(");
                if( paramTypes.length>0 ){
                    fundecl.append(" ");
                    for( int pi=0; pi<paramTypes.length; pi++ ){
                        if( pi>0 )fundecl.append(", ");

                        String argName = 
//                            (namesOfparam!=null && pi<namesOfparam.length && namesOfparam[pi]!=null) ?
//                            namesOfparam[pi] : "arg"+pi;
                            getParamNameOf(fun, pi);

                        String argTypeName = getTypeName(paramTypes[pi]);
                        fundecl.append(argName).append(":").append(argTypeName);
                    }
                    fundecl.append(" ");
                }
                fundecl.append(")");
            }
            
            Class retType = fun.getReturn();
            boolean retIsVoid = retType==null || ( 
                retType==Void.class || 
                retType.getName().equals("void") 
                );
            if( !retIsVoid ){
                fundecl.append(":").append(getTypeName(retType));
            }
        }else{
            fundecl.append("!no declare");
        }
        return fundecl.toString();
    }
}
