/*
 * The MIT License
 *
 * Copyright 2016 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.cli;


import java.util.logging.Level;
import java.util.logging.Logger;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jline.console.ConsoleReader;

/**
 *
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class JLineConsole 
implements Console
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(JLineConsole.class.getName());
    private static final Level logLevel = logger.getLevel();
    
    private static final boolean isLogSevere = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();
    
    private static final boolean isLogWarning = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();
    
    private static final boolean isLogInfo = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();
    
    private static final boolean isLogFine = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();
    
    private static final boolean isLogFiner = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();
    
    private static final boolean isLogFinest = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    //</editor-fold>
    
    protected ConsoleReader reader;
    protected PrintWriter writer;
    protected final Lock lock;
    
    public JLineConsole() throws IOException{
        reader = new ConsoleReader();
        lock = new ReentrantLock();
    }

    @Override
    public String readLine() {
        try {
            return reader.readLine();
        } catch (IOException ex) {
            Logger.getLogger(JLineConsole.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public void print(String text) {
        if( text==null )return;
        try {
            reader.print(text);
            reader.flush();
        } catch (IOException ex) {
            Logger.getLogger(JLineConsole.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
    @Override
    public void println() {
        try {
            reader.println();
            reader.flush();
        } catch (IOException ex) {
            Logger.getLogger(JLineConsole.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
    public ConsoleReader getConsoleReader(){
        return reader;
    }
    
    public static final String escape = "\u001B[";
    
    public static final String resetAttrEscape = "escape+\"0m\"";
    
    public static enum Color {
        Black,
        Red,
        Green,
        Yellow,
        Blue,
        Magenta,
        Cyan,
        White,
        LightBlack,
        LightRed,
        LightGreen,
        LightYellow,
        LightBlue,
        LightMagenta,
        LightCyan,
        LightWhite,
        Default;
        
        public String getBackgroudEscape(){
            switch( this ){
                case Black:             return (escape+"40m"); 
                case Red:               return (escape+"41m");
                case Green:             return (escape+"42m");
                case Yellow:            return (escape+"43m");
                case Blue:              return (escape+"44m");
                case Magenta:           return (escape+"45m");
                case Cyan:              return (escape+"46m");
                case White:             return (escape+"47m");
                case LightBlack:        return (escape+"100m");
                case LightRed:          return (escape+"101m");
                case LightGreen:        return (escape+"102m");
                case LightYellow:       return (escape+"103m");
                case LightBlue:         return (escape+"104m");
                case LightMagenta:      return (escape+"105m");
                case LightCyan:         return (escape+"106m");
                case LightWhite:        return (escape+"107m");
                case Default:           return (escape+"49m");
                    default:
                        return (escape+"49m");
            }
        }
        
        public String getForegroudEscape(){
            switch( this ){
                case Black:     return (escape+"30m");
                case Red:       return (escape+"31m");
                case Green:     return (escape+"32m");
                case Yellow:    return (escape+"33m");
                case Blue:      return (escape+"34m");
                case Magenta:   return (escape+"35m");
                case Cyan:      return (escape+"36m");
                case White:     return (escape+"37m");
                case LightBlack:     return (escape+"90m");
                case LightRed:       return (escape+"91m");
                case LightGreen:     return (escape+"92m");
                case LightYellow:    return (escape+"93m");
                case LightBlue:      return (escape+"94m");
                case LightMagenta:   return (escape+"95m");
                case LightCyan:      return (escape+"96m");
                case LightWhite:     return (escape+"97m");
                    default:
                        return (escape+"39m");
            }
        }
    }
}
