/*
 * The MIT License
 *
 * Copyright 2016 nt.gocha@gmail.com.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package xyz.cofe.cli;


import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Func3;
import xyz.cofe.collection.Func4;
import xyz.cofe.collection.Func5;
import xyz.cofe.collection.Func6;
import xyz.cofe.collection.Func7;
import xyz.cofe.collection.Func8;
import xyz.cofe.collection.Func9;
import xyz.cofe.collection.Pointer;
import xyz.cofe.collection.tree.AbstractTreeNode;
import xyz.cofe.text.parser.Token;

/**
 *
 * @author nt.gocha@gmail.com
 */
public class LambdaCall
extends AbstractTreeNode<Value>
implements Value
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(LambdaCall.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();

    private static final boolean isLogWarning =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();

    private static final boolean isLogInfo =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();

    private static final boolean isLogFine =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();

    private static final boolean isLogFiner =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();

    private static final boolean isLogFinest =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

//    public static class Undefined {
//    }

    protected final Lock lock = new ReentrantLock();

    public LambdaCall(){
    }

    //<editor-fold defaultstate="collapsed" desc="parser">
    protected Parser parser;

    public Parser getParser() {
        return parser;
    }

    public void setParser( Parser parser ) {
        this.parser = parser;
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="lambda">
    protected Parser.CatchedLambda lambda;

    public Parser.CatchedLambda getLambda() {
        return lambda;
    }

    public void setLambda( Parser.CatchedLambda lambda ) {
        this.lambda = lambda;
        this.fun = null;
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="type">
    protected Class type;

    @Override
    public Class getType() {
        return type;
    }

    public void setType( Class type ) {
        this.type = type;
        this.fun = null;
    }
//</editor-fold>

    @Override
    public Value[] getChildren() {
        return new Value[]{};
    }

    protected Object fun;

    protected Object getFun(){
        if( fun!=null )return fun;
        if( type==null )throw new IllegalArgumentException("type not set");
        if( type.equals(Func0.class) ){
            fun = createFunc0();
            if( fun!=null )return fun;
        }else if( type.equals(Func1.class) ){
            fun = createFunc1();
            if( fun!=null )return fun;
        }else if( type.equals(Func2.class) ){
            fun = createFunc2();
            if( fun!=null )return fun;
        }else if( type.equals(Func3.class) ){
            fun = createFunc3();
            if( fun!=null )return fun;
        }else if( type.equals(Func4.class) ){
            fun = createFunc4();
            if( fun!=null )return fun;
        }else if( type.equals(Func5.class) ){
            fun = createFunc5();
            if( fun!=null )return fun;
        }else if( type.equals(Func6.class) ){
            fun = createFunc6();
            if( fun!=null )return fun;
        }else if( type.equals(Func7.class) ){
            fun = createFunc7();
            if( fun!=null )return fun;
        }else if( type.equals(Func8.class) ){
            fun = createFunc8();
            if( fun!=null )return fun;
        }else if( type.equals(Func9.class) ){
            fun = createFunc9();
            if( fun!=null )return fun;
        }
        throw new Error("can't create fun");
    }

    //<editor-fold defaultstate="collapsed" desc="createFunc0">
    protected Func0 createFunc0(){
        final Parser p = parser;
        if( p==null ){
            throw new IllegalStateException("parser not set");
        }

        final Parser.CatchedLambda clambda = lambda;
        if( clambda==null ){
            throw new IllegalStateException("lambda not set");
        }

        if( clambda.body==null ){
            throw new IllegalStateException("lambda.body not set");
        }

        final Memory mem = parser.getMemory();
        if( mem==null ){
            throw new IllegalStateException("parser.memory not set");
        }

        Func0 f = new Func0() {
            @Override
            public Object apply() {
                if( clambda.args==null ){
                    throw new IllegalStateException("lambda.args not set");
                }
                if( clambda.args.size()>0 ){
                    throw new IllegalStateException("lambda.args.size > 0 for Func0");
                }
//                mem.put(clambda.args.get(0), arg);

                Value v = parser.parse(new Pointer<Token>(clambda.body));
                if( v==null ){
                    throw new IllegalStateException("can't parse lambda");
                }

                Object res = v.eval();

                return res;
            }
        };

        return f;
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="createFunc1">
    protected Func1 createFunc1(){
        final Parser p = parser;
        if( p==null ){
            throw new IllegalStateException("parser not set");
        }

        final Parser.CatchedLambda clambda = lambda;
        if( clambda==null ){
            throw new IllegalStateException("lambda not set");
        }

        if( clambda.body==null ){
            throw new IllegalStateException("lambda.body not set");
        }

        final Memory mem = parser.getMemory();
        if( mem==null ){
            throw new IllegalStateException("parser.memory not set");
        }

        Func1 f = new Func1() {
            @Override
            public Object apply( Object arg ) {
                if( clambda.args==null ){
                    throw new IllegalStateException("lambda.args not set");
                }
                if( clambda.args.size()>1 ){
                    throw new IllegalStateException("lambda.args.size > 1 for Func1");
                }
                mem.put(clambda.args.get(0), arg);

                Value v = parser.parse(new Pointer<Token>(clambda.body));
                if( v==null ){
                    throw new IllegalStateException("can't parse lambda");
                }

                Object res = v.eval();

                return res;
            }
        };

        return f;
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="createFunc2">
    protected Func2 createFunc2(){
        final Parser p = parser;
        if( p==null ){
            throw new IllegalStateException("parser not set");
        }

        final Parser.CatchedLambda clambda = lambda;
        if( clambda==null ){
            throw new IllegalStateException("lambda not set");
        }

        if( clambda.body==null ){
            throw new IllegalStateException("lambda.body not set");
        }

        final Memory mem = parser.getMemory();
        if( mem==null ){
            throw new IllegalStateException("parser.memory not set");
        }

        Func2 f = new Func2() {
            @Override
            public Object apply( Object arg1, Object arg2 ) {
                if( clambda.args==null ){
                    throw new IllegalStateException("lambda.args not set");
                }
                if( clambda.args.size()>2 ){
                    throw new IllegalStateException("lambda.args.size > 2 for Func2");
                }
                mem.put(clambda.args.get(0), arg1);
                mem.put(clambda.args.get(1), arg2);

                Value v = parser.parse(new Pointer<Token>(clambda.body));
                if( v==null ){
                    throw new IllegalStateException("can't parse lambda");
                }

                Object res = v.eval();

                return res;
            }
        };

        return f;
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="createFunc3">
    protected Func3 createFunc3(){
        final Parser p = parser;
        if( p==null ){
            throw new IllegalStateException("parser not set");
        }

        final Parser.CatchedLambda clambda = lambda;
        if( clambda==null ){
            throw new IllegalStateException("lambda not set");
        }

        if( clambda.body==null ){
            throw new IllegalStateException("lambda.body not set");
        }

        final Memory mem = parser.getMemory();
        if( mem==null ){
            throw new IllegalStateException("parser.memory not set");
        }

        Func3 f = new Func3() {
            @Override
            public Object apply( Object arg1, Object arg2, Object arg3 ) {
                if( clambda.args==null ){
                    throw new IllegalStateException("lambda.args not set");
                }
                if( clambda.args.size()>3 ){
                    throw new IllegalStateException("lambda.args.size > 3 for Func3");
                }
                mem.put(clambda.args.get(0), arg1);
                mem.put(clambda.args.get(1), arg2);
                mem.put(clambda.args.get(2), arg3);

                Value v = parser.parse(new Pointer<Token>(clambda.body));
                if( v==null ){
                    throw new IllegalStateException("can't parse lambda");
                }

                Object res = v.eval();

                return res;
            }
        };

        return f;
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="createFunc4">
    protected Func4 createFunc4(){
        final Parser p = parser;
        if( p==null ){
            throw new IllegalStateException("parser not set");
        }

        final Parser.CatchedLambda clambda = lambda;
        if( clambda==null ){
            throw new IllegalStateException("lambda not set");
        }

        if( clambda.body==null ){
            throw new IllegalStateException("lambda.body not set");
        }

        final Memory mem = parser.getMemory();
        if( mem==null ){
            throw new IllegalStateException("parser.memory not set");
        }

        Func4 f = new Func4() {
            @Override
            public Object apply( Object arg1, Object arg2, Object arg3,
                                 Object arg4
                               ) {
                if( clambda.args==null ){
                    throw new IllegalStateException("lambda.args not set");
                }
                if( clambda.args.size()>4 ){
                    throw new IllegalStateException("lambda.args.size > 4 for Func4");
                }
                mem.put(clambda.args.get(0), arg1);
                mem.put(clambda.args.get(1), arg2);
                mem.put(clambda.args.get(2), arg3);
                mem.put(clambda.args.get(3), arg4);

                Value v = parser.parse(new Pointer<Token>(clambda.body));
                if( v==null ){
                    throw new IllegalStateException("can't parse lambda");
                }

                Object res = v.eval();

                return res;
            }
        };

        return f;
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="createFunc5">
    protected Func5 createFunc5(){
        final Parser p = parser;
        if( p==null ){
            throw new IllegalStateException("parser not set");
        }

        final Parser.CatchedLambda clambda = lambda;
        if( clambda==null ){
            throw new IllegalStateException("lambda not set");
        }

        if( clambda.body==null ){
            throw new IllegalStateException("lambda.body not set");
        }

        final Memory mem = parser.getMemory();
        if( mem==null ){
            throw new IllegalStateException("parser.memory not set");
        }

        Func5 f = new Func5() {
            @Override
            public Object apply( Object arg1, Object arg2, Object arg3,
                                 Object arg4, Object arg5
                               ) {
                if( clambda.args==null ){
                    throw new IllegalStateException("lambda.args not set");
                }
                if( clambda.args.size()>5 ){
                    throw new IllegalStateException("lambda.args.size > 5 for Func5");
                }
                mem.put(clambda.args.get(0), arg1);
                mem.put(clambda.args.get(1), arg2);
                mem.put(clambda.args.get(2), arg3);
                mem.put(clambda.args.get(3), arg4);
                mem.put(clambda.args.get(4), arg5);

                Value v = parser.parse(new Pointer<Token>(clambda.body));
                if( v==null ){
                    throw new IllegalStateException("can't parse lambda");
                }

                Object res = v.eval();

                return res;
            }
        };

        return f;
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="createFunc6">
    protected Func6 createFunc6(){
        final Parser p = parser;
        if( p==null ){
            throw new IllegalStateException("parser not set");
        }

        final Parser.CatchedLambda clambda = lambda;
        if( clambda==null ){
            throw new IllegalStateException("lambda not set");
        }

        if( clambda.body==null ){
            throw new IllegalStateException("lambda.body not set");
        }

        final Memory mem = parser.getMemory();
        if( mem==null ){
            throw new IllegalStateException("parser.memory not set");
        }

        Func6 f = new Func6() {

            @Override
            public Object apply( Object arg1, Object arg2, Object arg3,
                                 Object arg4, Object arg5, Object arg6
                               ) {
                if( clambda.args==null ){
                    throw new IllegalStateException("lambda.args not set");
                }
                if( clambda.args.size()>6 ){
                    throw new IllegalStateException("lambda.args.size > 6 for Func6");
                }
                mem.put(clambda.args.get(0), arg1);
                mem.put(clambda.args.get(1), arg2);
                mem.put(clambda.args.get(2), arg3);
                mem.put(clambda.args.get(3), arg4);
                mem.put(clambda.args.get(4), arg5);
                mem.put(clambda.args.get(5), arg6);

                Value v = parser.parse(new Pointer<Token>(clambda.body));
                if( v==null ){
                    throw new IllegalStateException("can't parse lambda");
                }

                Object res = v.eval();

                return res;
            }
        };

        return f;
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="createFunc7">
    protected Func7 createFunc7(){
        final Parser p = parser;
        if( p==null ){
            throw new IllegalStateException("parser not set");
        }

        final Parser.CatchedLambda clambda = lambda;
        if( clambda==null ){
            throw new IllegalStateException("lambda not set");
        }

        if( clambda.body==null ){
            throw new IllegalStateException("lambda.body not set");
        }

        final Memory mem = parser.getMemory();
        if( mem==null ){
            throw new IllegalStateException("parser.memory not set");
        }

        Func7 f = new Func7() {

            @Override
            public Object apply( Object arg1, Object arg2, Object arg3,
                                 Object arg4, Object arg5, Object arg6,
                                 Object arg7
                               ) {
                if( clambda.args==null ){
                    throw new IllegalStateException("lambda.args not set");
                }
                if( clambda.args.size()>7 ){
                    throw new IllegalStateException("lambda.args.size > 7 for Func7");
                }
                mem.put(clambda.args.get(0), arg1);
                mem.put(clambda.args.get(1), arg2);
                mem.put(clambda.args.get(2), arg3);
                mem.put(clambda.args.get(3), arg4);
                mem.put(clambda.args.get(4), arg5);
                mem.put(clambda.args.get(5), arg6);
                mem.put(clambda.args.get(6), arg7);

                Value v = parser.parse(new Pointer<Token>(clambda.body));
                if( v==null ){
                    throw new IllegalStateException("can't parse lambda");
                }

                Object res = v.eval();

                return res;
            }
        };

        return f;
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="createFunc8">
    protected Func8 createFunc8(){
        final Parser p = parser;
        if( p==null ){
            throw new IllegalStateException("parser not set");
        }

        final Parser.CatchedLambda clambda = lambda;
        if( clambda==null ){
            throw new IllegalStateException("lambda not set");
        }

        if( clambda.body==null ){
            throw new IllegalStateException("lambda.body not set");
        }

        final Memory mem = parser.getMemory();
        if( mem==null ){
            throw new IllegalStateException("parser.memory not set");
        }

        Func8 f = new Func8() {

            @Override
            public Object apply( Object arg1, Object arg2, Object arg3,
                                 Object arg4, Object arg5, Object arg6,
                                 Object arg7, Object arg8
                               ) {
                if( clambda.args==null ){
                    throw new IllegalStateException("lambda.args not set");
                }
                if( clambda.args.size()>7 ){
                    throw new IllegalStateException("lambda.args.size > 8 for Func8");
                }
                mem.put(clambda.args.get(0), arg1);
                mem.put(clambda.args.get(1), arg2);
                mem.put(clambda.args.get(2), arg3);
                mem.put(clambda.args.get(3), arg4);
                mem.put(clambda.args.get(4), arg5);
                mem.put(clambda.args.get(5), arg6);
                mem.put(clambda.args.get(6), arg7);
                mem.put(clambda.args.get(7), arg8);

                Value v = parser.parse(new Pointer<Token>(clambda.body));
                if( v==null ){
                    throw new IllegalStateException("can't parse lambda");
                }

                Object res = v.eval();

                return res;
            }
        };

        return f;
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="createFunc9">
    protected Func9 createFunc9(){
        final Parser p = parser;
        if( p==null ){
            throw new IllegalStateException("parser not set");
        }

        final Parser.CatchedLambda clambda = lambda;
        if( clambda==null ){
            throw new IllegalStateException("lambda not set");
        }

        if( clambda.body==null ){
            throw new IllegalStateException("lambda.body not set");
        }

        final Memory mem = parser.getMemory();
        if( mem==null ){
            throw new IllegalStateException("parser.memory not set");
        }

        Func9 f = new Func9() {

            @Override
            public Object apply( Object arg1, Object arg2, Object arg3,
                                 Object arg4, Object arg5, Object arg6,
                                 Object arg7, Object arg8, Object arg9
                               ) {
                if( clambda.args==null ){
                    throw new IllegalStateException("lambda.args not set");
                }
                if( clambda.args.size()>7 ){
                    throw new IllegalStateException("lambda.args.size > 9 for Func9");
                }
                mem.put(clambda.args.get(0), arg1);
                mem.put(clambda.args.get(1), arg2);
                mem.put(clambda.args.get(2), arg3);
                mem.put(clambda.args.get(3), arg4);
                mem.put(clambda.args.get(4), arg5);
                mem.put(clambda.args.get(5), arg6);
                mem.put(clambda.args.get(6), arg7);
                mem.put(clambda.args.get(7), arg8);
                mem.put(clambda.args.get(8), arg9);

                Value v = parser.parse(new Pointer<Token>(clambda.body));
                if( v==null ){
                    throw new IllegalStateException("can't parse lambda");
                }

                Object res = v.eval();

                return res;
            }
        };

        return f;
    }
//</editor-fold>

    @Override
    public Object eval() {
        return getFun();
    }
}
