/*
 * The MIT License
 *
 * Copyright 2015 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"),
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ,
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ,
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.cli;


import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.map.BasicEventMap;
import xyz.cofe.collection.map.EventMap;
import xyz.cofe.collection.map.LockEventMap;
import xyz.cofe.collection.map.SimpleMapAdapter;
import xyz.cofe.collection.set.BasicEventSet;
import xyz.cofe.collection.set.LockEventSet;
import xyz.cofe.text.Text;

/**
 * Память
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class Memory
extends LockEventMap<String, Object>
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(Memory.class.getName());
    private static final Level logLevel = logger.getLevel();

    private static final boolean isLogSevere =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();

    private static final boolean isLogWarning =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();

    private static final boolean isLogInfo =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();

    private static final boolean isLogFine =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();

    private static final boolean isLogFiner =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();

    private static final boolean isLogFinest =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="constructors">
    public Memory(){
        super(
            new LinkedHashMap(),
            new ReentrantLock()
        );
        
        addEventMapListener(nameListener);
    }
    
    public Memory(Map<String,Object> wrappedMap){
        super(
            wrappedMap==null ? new LinkedHashMap<String, Object>() : wrappedMap,
            new ReentrantLock()
        );
        addEventMapListener(nameListener);
    }
    
    public Memory(Map<String,Object> wrappedMap, Lock lock){
        super(wrappedMap==null ? new LinkedHashMap<String, Object>() : wrappedMap,
            lock==null ? new ReentrantLock() : lock);
        
        addEventMapListener(nameListener);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="name map">
    private final WeakHashMap<Object,String> nameMap = new WeakHashMap<Object, String>();

    private void onNameAdded( final String key, final Object val ){
//        try {
//            lock.lock();
        lockRun( new Func0() {
            @Override
            public Object apply() {
         
            if( key!=null && 
                val!=null && 
                (val instanceof Function || val instanceof FunctionSet) &&
                key.startsWith(getOperatorPrefix()) 
            ){
                nameMap.put(val, Text.trimStart(key, getOperatorPrefix()));
                return null;
            }
            nameMap.put(val, key);
            return null;
        }});
//        }
//        finally {
//            lock.unlock();
//        }
    }

    private final SimpleMapAdapter<String,Object> nameListener = new SimpleMapAdapter<String, Object>(){
        @Override
        protected void added(Object value, EventMap<String, Object> map, String key) {
            onNameAdded(key, value);
        }
    };

    public String getNameOf( final Object value ){
        return (String)lockRun( new Func0() {
            @Override
            public Object apply() {
         
            if( value==null )return null;

            String name = nameMap.get(value);
            if( name!=null ){
                return name;
            }

            for( Map.Entry<String,Object> en : entrySet() ){
                name = en.getKey();
                Object obj = en.getValue();
                
                if( name==null )continue;
                
                if( value==obj ){
                    if( obj instanceof IsOperator && 
                        ((IsOperator)obj).isOperator()
                    ){
                        String res = //name.substring(getOperatorPrefix().length());
                            Text.trimStart(name, getOperatorPrefix());
                        nameMap.put(obj, res);
                        return res;
                    }
                    nameMap.put(obj, name);
                    return name;
                }
                
                if( obj instanceof FunctionSet ){
                    for( Function f : ((FunctionSet)obj).getFunctions() ){
                        if( value==f ){
                            if( obj instanceof IsOperator && 
                                ((IsOperator)obj).isOperator() && 
                                name.startsWith(getOperatorPrefix()) 
                            ){
                                String res = //name.substring(getOperatorPrefix().length());
                                    Text.trimStart(name, getOperatorPrefix());
                                nameMap.put(obj, res);
                                return res;
                            }
                            nameMap.put(obj, name);
                            return name;
                        }
                    }
                }
            }

            return null;
        }} );
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="operatorPrefix">
    protected String operatorPrefix = "$operator.";
    
    public String getOperatorPrefix() {
        return (String)lockRun( new Func0() {
            @Override
            public Object apply() {
            if( operatorPrefix==null ){
                operatorPrefix = "$operator.";
            }
            return operatorPrefix;
            }} );
    }
    
    public void setOperatorPrefix(final String operatorPrefix) {
        lockRun( new Func0() {
            @Override
            public Object apply() {
            Memory.this.operatorPrefix = operatorPrefix;
            return null;
            }});
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="getFunctions()">
    public FunctionSet getFunctions( final String name ){
        return (FunctionSet)lockRun(  new Func0() {
            @Override
            public Object apply() {
            if( name==null )return null;
            Object r = get( name );
            if( r instanceof Function || r instanceof FunctionSet ){
                if( r instanceof FunctionSet ){
                    FunctionSetImpl fset = new FunctionSetImpl();
                    int count = 0;
                    for( Function f : ((FunctionSet)r).getFunctions() ){
                        if( f==null )continue;
                        if( f instanceof IsOperator && ((IsOperator)f).isOperator() )continue;
                        fset.add(f);
                        count++;
                    }
                    return count>0 ? fset : null;
                }else if( r instanceof Function ){
                    if( !(r instanceof IsOperator && ((IsOperator)r).isOperator()) ){
                        FunctionSetImpl fset = new FunctionSetImpl();
                        fset.add((Function)r);
                        return fset;
                    }
                }
            }
            return null;
        }});
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="getOperators()">
    public FunctionSet getOperators( final String name ){
        return (FunctionSet)lockRun( new Func0(){
            @Override
            public Object apply() {
            if( name==null )return null;
            
            String opname = getOperatorPrefix()+Text.trimStart(name,getOperatorPrefix());
            Object r = get( opname );
            
            if( r instanceof Function || r instanceof FunctionSet ){
                if( r instanceof FunctionSet ){
                    FunctionSetImpl fset = new FunctionSetImpl();
                    int count = 0;
                    for( Function f : ((FunctionSet)r).getFunctions() ){
                        if( f==null )continue;
                        if( f instanceof IsOperator && ((IsOperator)f).isOperator() ){
                            fset.add(f);
                            count++;
                        }
                    }
                    return count>0 ? fset : null;
                }else if( r instanceof Function ){
                    if( r instanceof IsOperator && ((IsOperator)r).isOperator() ){
                        FunctionSetImpl fset = new FunctionSetImpl();
                        fset.add((Function)r);
                        return fset;
                    }
                }
            }
            return null;
        }} );
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="consts">
    protected Set<String> consts;
    
    public Set<String> getConsts() {
        return (Set)lockRun( new Func0() {
            @Override
            public Object apply() {
            if( consts!=null )return consts;
            consts = new LockEventSet<String>(
                    new LinkedHashSet<String>(),
                    getLockWrite()
                );
            return consts;
        }});
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="getFunTypeDesc()">
    protected String getFunTypeDesc( final Function fun ){
        if( fun==null )throw new IllegalArgumentException( "fun==null" );
        List<String> types = new ArrayList<String>();
        types.add(fun.getReturn().getName());
        for( Class p : fun.getParameters() ){
            types.add(p.getName());
        }
        return "("+Text.join(types, ",")+")";
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="put()">
    @Override
    public Object put(String key, Object value) {
        if( key!=null && value!=null && value instanceof Function ){
            add( key, (Function)value );
            return null;
        }
        return super.put(key, value);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="add()">
    public void add( final String key, final Function fun ){
        lockRun( new Func0() {
            @Override
            public Object apply() {
         
            if( key==null )throw new IllegalArgumentException( "key==null" );
            if( fun==null )throw new IllegalArgumentException( "fun==null" );
            
            boolean isop = fun instanceof IsOperator
                ? ((IsOperator)fun).isOperator()
                : false;
            
            String addkey = isop ? getOperatorPrefix()+key : key;
            Object v = get( addkey );
            
            if( v!=null && v instanceof Function ){
                Function fexists = (Function)v;
                
                String decl1 = getFunTypeDesc(fun);
                String decl2 = getFunTypeDesc(fexists);
                
                if( decl1.equals(decl2) ){
                    Memory.super.put( addkey, fun );
                }else{
                    FunctionSetImpl funs = new FunctionSetImpl();
                    funs.add((Function)v);
                    funs.add(fun);
                    Memory.super.put(addkey, funs);
                }
            }else if( v!=null && v instanceof FunctionSet ){
                String decl1 = getFunTypeDesc(fun);
                
                FunctionSetImpl funs = new FunctionSetImpl();
                for( Function f : ((FunctionSet)v).getFunctions() ){
                    String decl2 = getFunTypeDesc(f);
                    if( ! decl1.equals(decl2) ){
                        funs.add(f);
                    }
                }
                funs.add(fun);
                Memory.super.put(addkey, funs);
            }else{
                Memory.super.put(addkey, fun);
            }
            
            return null;
            }});
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="inspect()">
    public void inspect( Object own ){
        inspect(own, null);
    }
    
    public void inspect( Object own, CommandLineMachine cli ){
        if( own==null )throw new IllegalArgumentException( "own==null" );
//        if( cli==null )throw new IllegalArgumentException( "cli==null" );
        
        FunctionBuilder fb = new FunctionBuilder();
        fb.setCmdMachine(cli);
        
        Function[] funs = fb.create(own, Fun.class);
        for( Function fun : funs ){
            if( fun instanceof SetMemory ){
                ((SetMemory)fun).setMemory(this);
            }
            
            if( fun instanceof FunctionBuilder.MethodCall ){
                FunctionBuilder.MethodCall mc = ( FunctionBuilder.MethodCall )fun;
                Method m = mc.getMethod();
                
                Fun fn = m.getAnnotation(Fun.class);
                if( fn!=null && fn.operator() )mc.setOperator(true);
                
                Name nameann = m.getAnnotation(Name.class);
                String n = nameann==null ? m.getName() : nameann.name();
                
                this.add(n, mc);
                
                if( fn!=null && fn.readonly() ){
                    this.getConsts().add(n);
                }
            }
        }
    }
    //</editor-fold>
}
