/*
 * The MIT License
 *
 * Copyright 2015 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.cli;


import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.graph.Path;
import xyz.cofe.typeconv.ExtendedCastGraph;
import xyz.cofe.typeconv.TypeCastGraph;

/**
 *
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class TypeCastValue 
extends BasicValue
implements GetType
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(TypeCastValue.class.getName());
    private static final Level logLevel = logger.getLevel();
    
    private static final boolean isLogSevere = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();
    
    private static final boolean isLogWarning = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();
    
    private static final boolean isLogInfo = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();
    
    private static final boolean isLogFine = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();
    
    private static final boolean isLogFiner = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();
    
    private static final boolean isLogFinest = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="fromType">
    private Class fromType;
    
    public Class getFromType() {
        return fromType;
    }
    
    public void setFromType(Class fromType) {
        this.fromType = fromType;
    }
//</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="type">
    private Class type;
    
    @Override
    public Class getType() {
        return type;
    }
    
    public void setType(Class type) {
        this.type = type;
    }
//</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="value">
//    private Value value;
//    
    public Value getValue() {
        Value[] children = getChildren();
        Value value = (children!=null && children.length>0) ? children[0] : null;
        return value;
    }
//    
//    public void setValue(Value value) {
//        this.value = value;
//    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="typeCastGraph">
    private TypeCastGraph typeCastGraph;
    
    public TypeCastGraph getTypeCastGraph() {
        if( typeCastGraph!=null ){
            return typeCastGraph;
        }
        typeCastGraph = new ExtendedCastGraph();
        return typeCastGraph;
    }
    
    public void setTypeCastGraph(TypeCastGraph typeCastGraph) {
        this.typeCastGraph = typeCastGraph;
    }
//</editor-fold>
    
    public boolean canCast(){
        TypeCastGraph tcg = getTypeCastGraph();
        if( tcg==null )return false;
        
        if( fromType==null )return false;
        if( type==null )return false;
        
        Path<Class,Convertor<Object,Object>> p = tcg.findPath(fromType, type);
        if( p!=null )return true;
        
        return false;
    }
    
    private boolean implicit = false;

    public boolean isImplicit() {
        return implicit;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }
    
    @Override
    public Object eval() {
        Class ftype = fromType;
        Value[] children = getChildren();
        Value value = (children!=null && children.length>0) ? children[0] : null;
        
        if( ftype==null && value instanceof ConstValue ){
            ftype = ((ConstValue)value).getType();
        }
        
        Class ttype = type;
        if( ttype==Void.class )return null;
        if( ttype==null )throw new IllegalStateException("target type not setted");
        
        if( ftype==null )throw new IllegalStateException("source type not setted");
        
        Value val = value;
        if( val==null )throw new IllegalStateException("source value not setted");
        
        if( ttype.equals(ftype) )return val.eval();
        
        Object srcv = val.eval();
        if( srcv==null )throw new IllegalStateException("source evaled value is null");
        
//        Class srct = srcv.getClass();
//        if( !srct.equals(ftype) )throw new IllegalStateException("source evaled value is not equals "+ftype);
        
        TypeCastGraph tc = getTypeCastGraph();
        Object retval = tc.cast(srcv, ttype);
        
        if( retval==null )
            throw new IllegalStateException(
                "can't cast "
                    +(srcv==null ? "null" : srcv.getClass().getName())
                    +" to "+ttype+" (null)");
        
        return retval;
    }
    
//    @Override
//    public String toString(){
//        Value[] children = getChildren();
//        Value value = (children!=null && children.length>0) ? children[0] : null;
//
//        Value val = value;
//        if( val==null )
//            return "!cast(null)";
//        
//        Class ftype = fromType;
//        if( ftype==null && value instanceof ConstValue ){
//            ftype = ((ConstValue)value).getType();
//        }
//        
//        Class ttype = type;
//        if( ttype==null )return "!cast(target=null)";
//        if( ttype==Void.class ){
//            return val.toString() + " as void";
//        }
//        
//        String ttname = ttype.getName();
//        if( ttype==Integer.class ){
//            ttname = "Integer";
//        }else if( ttype==Boolean.class ){
//            ttname = "Boolean";
//        }else if( ttype==String.class ){
//            ttname = "String";
//        }else if( ttype==int.class ){
//            ttname = "int";
//        }else if( ttype==boolean.class ){
//            ttname = "boolean";
//        }else if( ttype==Double.class ){
//            ttname = "Double";
//        }else if( ttype==double.class ){
//            ttname = "double";
//        }else if( ttype==Float.class ){
//            ttname = "Float";
//        }else if( ttype==float.class ){
//            ttname = "float";
//        }else if( ttype==Long.class ){
//            ttname = "Long";
//        }else if( ttype==long.class ){
//            ttname = "long";
//        }else if( ttype==Short.class ){
//            ttname = "Short";
//        }else if( ttype==short.class ){
//            ttname = "short";
//        }else if( ttype==Byte.class ){
//            ttname = "Byte";
//        }else if( ttype==byte.class ){
//            ttname = "byte";
//        }
//        
//        return "("+val.toString() + " as "+ttname+")";
//    }
}
