/*
 * The MIT License
 *
 * Copyright 2016 user.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package xyz.cofe.cli.fun;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.BaseCLIFun;
import xyz.cofe.cli.Fun;
import xyz.cofe.cli.Name;

/**
 *
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class BooleanFn
extends BaseCLIFun
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(BooleanFn.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();

    private static final boolean isLogWarning =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();

    private static final boolean isLogInfo =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();

    private static final boolean isLogFine =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();

    private static final boolean isLogFiner =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();

    private static final boolean isLogFinest =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

//    public final UpMain upmain;
//    public static final WeakHashMap<Repo, String> repoNameMap = new WeakHashMap<Repo, String>();

//    public BooleanFn( UpMain upmain ){
//        if( upmain==null )throw new IllegalArgumentException( "upmain==null" );
//        this.upmain = upmain;
//    }
//
//    public void println(){
//        upmain.getOutput().println();
//    }
//
//    public void println(Object obj){
//        upmain.getOutput().println(obj);
//    }
//
//    public BasicTemplate.EasyTemplate template(String template){
//        return upmain.getOutput().template(template);
//    }

    //TODO doc it
    @Fun(operator = true) @Name (name = "&")
    public Boolean boolAnd( Boolean b1, Boolean b2 ){
        if( b1==null )throw new IllegalArgumentException( "b1==null" );
        if( b2==null )return false;

        return b1 && b2;
    }

    //TODO doc it
    @Fun(operator = true) @Name (name = "and")
    public Boolean boolAndNamed( Boolean b1, Boolean b2 ){
        if( b1==null )throw new IllegalArgumentException( "b1==null" );
        if( b2==null )return false;

        return b1 && b2;
    }

    //TODO doc it
    @Fun(operator = true) @Name (name = "|")
    public Boolean boolOr( Boolean b1, Boolean b2 ){
        if( b1==null )throw new IllegalArgumentException( "b1==null" );
        if( b2==null )return false;

        return b1 || b2;
    }

    //TODO doc it
    @Fun(operator = true) @Name (name = "or")
    public Boolean boolOrNamed( Boolean b1, Boolean b2 ){
        if( b1==null )throw new IllegalArgumentException( "b1==null" );
        if( b2==null )return false;

        return b1 || b2;
    }

    //TODO doc it
    @Fun(operator = false) @Name(name = "!")
    public Boolean boolNot( Boolean b1 ){
        if( b1==null )throw new IllegalArgumentException( "b1==null" );
        return ! b1;
    }

    //TODO doc it
    @Fun(operator = false) @Name(name = "not")
    public Boolean boolNotNamed( Boolean b1 ){
        if( b1==null )throw new IllegalArgumentException( "b1==null" );
        return ! b1;
    }
}
