/*
 * The MIT License
 *
 * Copyright 2016 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"),
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ,
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ,
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.cli.fun;


import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.BaseCLIFun;
import xyz.cofe.cli.Fun;
import xyz.cofe.cli.Help;
import xyz.cofe.cli.Name;
import xyz.cofe.collection.Func1;
import xyz.cofe.fs.ByteSize;
import xyz.cofe.fs.File;
import xyz.cofe.fs.FileSystems;
import xyz.cofe.fs.FileVisitor;

/**
 *
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class FileFn
extends BaseCLIFun
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(FileFn.class.getName());
    private static final Level logLevel = logger.getLevel();

    private static final boolean isLogSevere =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();

    private static final boolean isLogWarning =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();

    private static final boolean isLogInfo =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();

    private static final boolean isLogFine =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();

    private static final boolean isLogFiner =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();

    private static final boolean isLogFinest =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

    @Fun
    @Help(shortDesc = "create file object")
    public File file( 
        @Help(shortDesc = "path to file/dir")
        @Name(name = "path")
        String path 
    ){
        if( path==null )throw new IllegalArgumentException( "path==null" );
        return FileSystems.get(path);
    }

    @Fun(operator = true)
    @Help(shortDesc = "return file name")
    public String name(File file){
        if( file==null )throw new IllegalArgumentException( "file==null" );
        return file.getName();
    }

    @Fun(operator = true)
    @Help(shortDesc = "return file path")
    public String path(File file){
        if( file==null )throw new IllegalArgumentException( "file==null" );
        return file.getPath();
    }

    @Fun(operator = true)
    @Help(shortDesc = "return file modify time")
    public Date modifyDate(File file){
        if( file==null )throw new IllegalArgumentException( "file==null" );
        return file.getModifyDate();
    }

    @Fun(operator = true)
    @Help(shortDesc = "return true is file is directory")
    public Boolean isDirectory(File file){
        if( file==null )throw new IllegalArgumentException( "file==null" );
        return file.isDirectory();
    }

    @Fun(operator = true)
    @Help(shortDesc = "return true is file is regular file")
    public Boolean isFile(File file){
        if( file==null )throw new IllegalArgumentException( "file==null" );
        return file.isFile();
    }

    @Fun(operator = true)
    @Help(shortDesc = "return true is file has parent directory")
    public Boolean hasParent(File file){
        if( file==null )throw new IllegalArgumentException( "file==null" );
        return file.getParent() != null;
    }

    @Fun(operator = true)
    @Help(shortDesc = "return parent directory of file")
    public File parent(File file){
        if( file==null )throw new IllegalArgumentException( "file==null" );
        return file.getParent();
    }

    @Fun(operator = true)
    @Help(shortDesc = "return file length")
    public long length(File file){
        if( file==null )throw new IllegalArgumentException( "file==null" );
        return file.getLength();
    }

    @Fun(operator = true)
    @Help(shortDesc = "return file length as string")
    public String lengthString(File file){
        if( file==null )throw new IllegalArgumentException( "file==null" );
        return new ByteSize(file.getLength()).toStringRoundMin(2);
    }

    @Fun(operator = true)
    @Help(shortDesc = "output file content")
    public void print(File file){
        if( file==null )throw new IllegalArgumentException( "file==null" );
        try{
            InputStream fin = file.openRead();
            InputStreamReader rd = new InputStreamReader(fin, Charset.defaultCharset());
            char[] cbuf = new char[1024*8];
            while( true ){
                int readed = rd.read(cbuf);
                if( readed<=0 )break;
                getOutput().print( new String(cbuf,0,readed) );
            }
            fin.close();
        }catch( Throwable err ){
            err.toString();
        }
    }
}
