/*
 * The MIT License
 *
 * Copyright 2016 user.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package xyz.cofe.cli.fun;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.BaseCLIFun;
import xyz.cofe.cli.Fun;
import xyz.cofe.cli.Name;

/**
 *
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class NumberFn
extends BaseCLIFun
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(NumberFn.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();

    private static final boolean isLogWarning =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();

    private static final boolean isLogInfo =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();

    private static final boolean isLogFine =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();

    private static final boolean isLogFiner =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();

    private static final boolean isLogFinest =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

//    public final UpMain upmain;
//    public static final WeakHashMap<Repo, String> repoNameMap = new WeakHashMap<Repo, String>();
//
//    public NumberFn( UpMain upmain ){
//        if( upmain==null )throw new IllegalArgumentException( "upmain==null" );
//        this.upmain = upmain;
//    }
//
//    public void println(){
//        upmain.getOutput().println();
//    }
//
//    public void println(Object obj){
//        upmain.getOutput().println(obj);
//    }
//
//    public BasicTemplate.EasyTemplate template(String template){
//        return upmain.getOutput().template(template);
//    }

    //<editor-fold defaultstate="collapsed" desc="compare numbers">
    //TODO doc it
    @Fun(operator = true) @Name( name = "==" )
    public Boolean cmpEquals( Number num1, Number num2 ){
        if( num1==null )throw new IllegalArgumentException( "num1==null" );
        if( num2==null )throw new IllegalArgumentException( "num2==null" );

        if( num1 instanceof Long ){
            return num1.longValue() == num2.longValue();
        }else if( num1 instanceof Integer ){
            if( num2 instanceof Long ){
                return num1.longValue() == num2.longValue();
            }else{
                return num1.intValue() == num2.intValue();
            }
        }else if( num1 instanceof Short ){
            if( num2 instanceof Long ){
                return num1.longValue() == num2.longValue();
            }
            if( num2 instanceof Integer ){
                return num1.intValue() == num2.intValue();
            }
            return num1.shortValue() == num2.shortValue();
        }else if( num1 instanceof Byte ){
            if( num2 instanceof Long ){
                return num1.longValue() == num2.longValue();
            }
            if( num2 instanceof Integer ){
                return num1.intValue() == num2.intValue();
            }
            if( num2 instanceof Short ){
                return num1.shortValue() == num2.shortValue();
            }
            return num1.byteValue() == num2.byteValue();
        }else if( num1 instanceof Double ){
            return num1.doubleValue() == num2.doubleValue();
        }else if( num1 instanceof Float ){
            if( num2 instanceof Double ){
                return num1.doubleValue() == num2.doubleValue();
            }
            return num1.floatValue() == num2.floatValue();
        }

        return num1.equals(num2);
    }

    //TODO doc it
    @Fun(operator = true) @Name( name = "equ" )
    public Boolean cmpEqualsNamed( Number num1, Number num2 ){
        return cmpEquals(num1, num2);
    }

    //TODO doc it
    @Fun(operator = true) @Name( name = "!=" )
    public Boolean cmpNotEquals( Number num1, Number num2 ){
        boolean r = cmpEquals(num1, num2);
        return !r;
    }

    //TODO doc it
    @Fun(operator = true) @Name( name = "nequ" )
    public Boolean cmpNotEqualsNamed( Number num1, Number num2 ){
        boolean r = cmpEquals(num1, num2);
        return !r;
    }

    //TODO doc it
    @Fun(operator = true) @Name( name = "more" )
    public Boolean cmpMoreNamed( Number num1, Number num2 ){
        return cmpMore(num1, num2);
    }

    //TODO doc it
    @Fun(operator = true) @Name( name = ">" )
    public Boolean cmpMore( Number num1, Number num2 ){
        if( num1==null )throw new IllegalArgumentException( "num1==null" );
        if( num2==null )throw new IllegalArgumentException( "num2==null" );

        if( num1 instanceof Long ){
            return num1.longValue() > num2.longValue();
        }else if( num1 instanceof Integer ){
            if( num2 instanceof Long ){
                return num1.longValue() > num2.longValue();
            }else{
                return num1.intValue() > num2.intValue();
            }
        }else if( num1 instanceof Short ){
            if( num2 instanceof Long ){
                return num1.longValue() > num2.longValue();
            }
            if( num2 instanceof Integer ){
                return num1.intValue() > num2.intValue();
            }
            return num1.shortValue() > num2.shortValue();
        }else if( num1 instanceof Byte ){
            if( num2 instanceof Long ){
                return num1.longValue() > num2.longValue();
            }
            if( num2 instanceof Integer ){
                return num1.intValue() > num2.intValue();
            }
            if( num2 instanceof Short ){
                return num1.shortValue() > num2.shortValue();
            }
            return num1.byteValue() > num2.byteValue();
        }else if( num1 instanceof Double ){
            return num1.doubleValue() > num2.doubleValue();
        }else if( num1 instanceof Float ){
            if( num2 instanceof Double ){
                return num1.doubleValue() > num2.doubleValue();
            }
            return num1.floatValue() > num2.floatValue();
        }

        if( num1 instanceof Comparable ){
            int r = ((Comparable)num1).compareTo(num2);
            if( r>0 )return true;
            return false;
        }

        throw new Error("can't compare "+num1+" and "+num2);
    }

    //TODO doc it
    @Fun(operator = true) @Name( name = "less" )
    public Boolean cmpLessNamed( Number num1, Number num2 ){
        return cmpLess(num1, num2);
    }

    //TODO doc it
    @Fun(operator = true) @Name( name = "<" )
    public Boolean cmpLess( Number num1, Number num2 ){
        if( num1==null )throw new IllegalArgumentException( "num1==null" );
        if( num2==null )throw new IllegalArgumentException( "num2==null" );

        if( num1 instanceof Long ){
            return num1.longValue() < num2.longValue();
        }else if( num1 instanceof Integer ){
            if( num2 instanceof Long ){
                return num1.longValue() < num2.longValue();
            }else{
                return num1.intValue() < num2.intValue();
            }
        }else if( num1 instanceof Short ){
            if( num2 instanceof Long ){
                return num1.longValue() < num2.longValue();
            }
            if( num2 instanceof Integer ){
                return num1.intValue() < num2.intValue();
            }
            return num1.shortValue() < num2.shortValue();
        }else if( num1 instanceof Byte ){
            if( num2 instanceof Long ){
                return num1.longValue() < num2.longValue();
            }
            if( num2 instanceof Integer ){
                return num1.intValue() < num2.intValue();
            }
            if( num2 instanceof Short ){
                return num1.shortValue() < num2.shortValue();
            }
            return num1.byteValue() > num2.byteValue();
        }else if( num1 instanceof Double ){
            return num1.doubleValue() < num2.doubleValue();
        }else if( num1 instanceof Float ){
            if( num2 instanceof Double ){
                return num1.doubleValue() < num2.doubleValue();
            }
            return num1.floatValue() < num2.floatValue();
        }

        if( num1 instanceof Comparable ){
            int r = ((Comparable)num1).compareTo(num2);
            if( r<0 )return true;
            return false;
        }

        throw new Error("can't compare "+num1+" and "+num2);
    }

    //TODO doc it
    @Fun(operator = true) @Name( name = "moreEqu" )
    public Boolean cmpMoreOrEqualsNamed( Number num1, Number num2 ){
        return cmpMoreOrEquals(num1, num2);
    }

    //TODO doc it
    @Fun(operator = true) @Name( name = "<=" )
    public Boolean cmpMoreOrEquals( Number num1, Number num2 ){
        boolean r = cmpLess(num1, num2);
        return !r;
    }

    //TODO doc it
    @Fun(operator = true) @Name( name = "lessEqu" )
    public Boolean cmpLessOrEqualsNamed( Number num1, Number num2 ){
        return cmpLessOrEquals(num1, num2);
    }

    //TODO doc it
    @Fun(operator = true) @Name( name = ">=" )
    public Boolean cmpLessOrEquals( Number num1, Number num2 ){
        boolean r = cmpMore(num1, num2);
        return !r;
    }
//</editor-fold>

    //TODO doc it
    @Fun(operator = true) @Name(name = "+")
    public Integer add( Integer a, Integer b ){
        if( a==null )throw new IllegalArgumentException( "a==null" );
        if( b==null )throw new IllegalArgumentException( "b==null" );
        return a + b;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "add")
    public Integer addNamed( Integer a, Integer b ){
        if( a==null )throw new IllegalArgumentException( "a==null" );
        if( b==null )throw new IllegalArgumentException( "b==null" );
        return a + b;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "+")
    public Long add( Long a, Long b ){
        if( a==null )throw new IllegalArgumentException( "a==null" );
        if( b==null )throw new IllegalArgumentException( "b==null" );
        return a + b;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "add")
    public Long addNamed( Long a, Long b ){
        if( a==null )throw new IllegalArgumentException( "a==null" );
        if( b==null )throw new IllegalArgumentException( "b==null" );
        return a + b;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "-")
    public Integer sub( Integer a, Integer b ){
        if( a==null )throw new IllegalArgumentException( "a==null" );
        if( b==null )throw new IllegalArgumentException( "b==null" );
        return a - b;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "sub")
    public Integer subNamed( Integer a, Integer b ){
        if( a==null )throw new IllegalArgumentException( "a==null" );
        if( b==null )throw new IllegalArgumentException( "b==null" );
        return a - b;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "-")
    public Long sub( Long a, Long b ){
        if( a==null )throw new IllegalArgumentException( "a==null" );
        if( b==null )throw new IllegalArgumentException( "b==null" );
        return a - b;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "sub")
    public Long subNamed( Long a, Long b ){
        if( a==null )throw new IllegalArgumentException( "a==null" );
        if( b==null )throw new IllegalArgumentException( "b==null" );
        return a - b;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "*")
    public Integer mul( Integer a, Integer b ){
        if( a==null )throw new IllegalArgumentException( "a==null" );
        if( b==null )throw new IllegalArgumentException( "b==null" );
        return a * b;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "mul")
    public Integer mulNamed( Integer a, Integer b ){
        if( a==null )throw new IllegalArgumentException( "a==null" );
        if( b==null )throw new IllegalArgumentException( "b==null" );
        return a * b;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "*")
    public Long mul( Long a, Long b ){
        if( a==null )throw new IllegalArgumentException( "a==null" );
        if( b==null )throw new IllegalArgumentException( "b==null" );
        return a * b;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "mul")
    public Long mulNamed( Long a, Long b ){
        if( a==null )throw new IllegalArgumentException( "a==null" );
        if( b==null )throw new IllegalArgumentException( "b==null" );
        return a * b;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "/")
    public Integer div( Integer a, Integer b ){
        if( a==null )throw new IllegalArgumentException( "a==null" );
        if( b==null )throw new IllegalArgumentException( "b==null" );
        return a / b;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "div")
    public Integer divNamed( Integer a, Integer b ){
        if( a==null )throw new IllegalArgumentException( "a==null" );
        if( b==null )throw new IllegalArgumentException( "b==null" );
        return a / b;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "/")
    public Long div( Long a, Long b ){
        if( a==null )throw new IllegalArgumentException( "a==null" );
        if( b==null )throw new IllegalArgumentException( "b==null" );
        return a / b;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "div")
    public Long divNamed( Long a, Long b ){
        if( a==null )throw new IllegalArgumentException( "a==null" );
        if( b==null )throw new IllegalArgumentException( "b==null" );
        return a / b;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "/")
    // modulo
    public Integer mod( Integer a, Integer b ){
        if( a==null )throw new IllegalArgumentException( "a==null" );
        if( b==null )throw new IllegalArgumentException( "b==null" );
        return a % b;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "mod")
    // modulo
    public Integer modNamed( Integer a, Integer b ){
        if( a==null )throw new IllegalArgumentException( "a==null" );
        if( b==null )throw new IllegalArgumentException( "b==null" );
        return a % b;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "/")
    public Long mod( Long a, Long b ){
        if( a==null )throw new IllegalArgumentException( "a==null" );
        if( b==null )throw new IllegalArgumentException( "b==null" );
        return a % b;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "mod")
    public Long modNamed( Long a, Long b ){
        if( a==null )throw new IllegalArgumentException( "a==null" );
        if( b==null )throw new IllegalArgumentException( "b==null" );
        return a % b;
    }
}
